/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.server.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class HasMoreList<T> {
    private final ImmutableList<T> _subList;
    private final boolean _hasMore;

    public HasMoreList(ImmutableList<T> subList, boolean hasMore) {
        this._subList = subList;
        this._hasMore = hasMore;
    }

    @Nonnull
    public ImmutableList<T> getSubList() {
        return this._subList;
    }

    public boolean isHasMore() {
        return this._hasMore;
    }

    @Nonnull
    public static <I> HasMoreList<I> fromList(ImmutableList<I> items, int intendedLimit) {
        int size = items.size();
        return new HasMoreList(items.subList(0, Math.min(intendedLimit, size)), size > intendedLimit);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subList", this._subList.size()).add("hasMore", this._hasMore).toString();
    }
}

