/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.server.model;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.MoreObjects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractTypeIdResolver<T>
implements TypeIdResolver {
    private JavaType _baseType;

    public void init(JavaType baseType) {
        this._baseType = baseType;
    }

    public String idFromValue(Object value) {
        return this.idFromValueAndType(value, value.getClass());
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        String id = this.toId(value, suggestedType);
        if (id == null) {
            throw new IllegalStateException("Unable to find custom type id for class " + suggestedType.getName());
        }
        return id;
    }

    @CheckForNull
    public abstract String toId(@Nullable T var1, @Nonnull Class<? extends T> var2);

    public String idFromBaseType() {
        return this.idFromValueAndType(null, this._baseType.getRawClass());
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        return this.typeFromId(context.getTypeFactory(), id);
    }

    @Nonnull
    private JavaType typeFromId(@Nonnull TypeFactory typeFactory, @Nonnull String id) {
        Class<T> clazz = this.fromId(id);
        if (clazz == null) {
            throw new IllegalStateException("cannot find matching class for type id value '" + id + "' and basic class " + this.getDescForKnownTypeIds());
        }
        return typeFactory.constructSpecializedType(this._baseType, clazz);
    }

    public String getDescForKnownTypeIds() {
        return this._baseType.getRawClass().getName();
    }

    @CheckForNull
    public abstract Class<? extends T> fromId(@Nonnull String var1);

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseType", (Object)this._baseType).toString();
    }
}

