/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.server;

import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class FileUploadRestTemplate
extends RestTemplate {
    private static final ImmutableList<HttpMessageConverter<?>> CONVERTERS = FileUploadRestTemplate.converter();
    private static final int ONE_KB = 1024;
    private static final long ONE_MB = 0x100000L;

    public FileUploadRestTemplate(long contentLength) {
        super(CONVERTERS);
        this.setRequestFactory((ClientHttpRequestFactory)this.requestFactory(contentLength));
    }

    @Nonnull
    private SimpleClientHttpRequestFactory requestFactory(long contentLength) {
        int timeOut = this.timeout(contentLength);
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        if (contentLength > 0xA00000L) {
            requestFactory.setBufferRequestBody(false);
            requestFactory.setChunkSize(4096);
        }
        requestFactory.setReadTimeout(timeOut);
        requestFactory.setConnectTimeout(timeOut);
        return requestFactory;
    }

    private int timeout(long contentLength) {
        return Long.valueOf(Math.max(TimeUnit.SECONDS.toMillis(10L), Math.min(contentLength / 10L, TimeUnit.HOURS.toMillis(1L)))).intValue();
    }

    @Nonnull
    private static ImmutableList<HttpMessageConverter<?>> converter() {
        AllEncompassingFormHttpMessageConverter formHttpMessageConverter = new AllEncompassingFormHttpMessageConverter();
        formHttpMessageConverter.setCharset(StandardCharsets.UTF_8);
        formHttpMessageConverter.setMultipartCharset(StandardCharsets.UTF_8);
        return ImmutableList.builder().add((Object)new ByteArrayHttpMessageConverter()).add((Object)new StringHttpMessageConverter(StandardCharsets.UTF_8)).add((Object)new ResourceHttpMessageConverter()).add((Object)new SourceHttpMessageConverter()).add((Object)formHttpMessageConverter).add((Object)new MappingJackson2HttpMessageConverter()).build();
    }
}

