/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.rest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.authorization.business.ProfileRole;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.common.rest.AppIdDeserializer;
import de.justsoftware.onx.common.rest.AppIdSerializer;
import de.justsoftware.onx.common.rest.ItemIdDeserializer;
import de.justsoftware.onx.common.rest.ItemIdSerializer;
import de.justsoftware.onx.common.rest.LongIdSerializer;
import de.justsoftware.onx.common.rest.NotificationIdDeserializer;
import de.justsoftware.onx.common.rest.PersonIdDeserializer;
import de.justsoftware.onx.common.rest.ProfileRoleKeyDeserializer;
import de.justsoftware.onx.common.rest.ProfileRoleKeySerializer;
import de.justsoftware.onx.common.rest.PushNotificationDeviceRegistrationIdDeserializer;
import de.justsoftware.onx.common.rest.PushNotificationDeviceRegistrationIdSerializer;
import de.justsoftware.onx.common.rest.SectionIdSerializer;
import de.justsoftware.onx.common.rest.StringLiteralSerializer;
import de.justsoftware.onx.common.rest.TaskFilterIdDeserializer;
import de.justsoftware.onx.common.rest.TaskFilterIdSerializer;
import de.justsoftware.onx.common.server.model.IdType;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.onx.document.shared.model.DocumentId;
import de.justsoftware.onx.link.shared.model.LinkId;
import de.justsoftware.onx.notifications.shared.model.NotificationId;
import de.justsoftware.onx.push.shared.model.PushRegistrationId;
import de.justsoftware.onx.tasks.shared.model.TaskFilterId;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JucoObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = -1561373094221549395L;

    public JucoObjectMapper() {
        this.init();
    }

    public JucoObjectMapper(@Nullable JsonFactory jsonFactory) {
        super(jsonFactory);
        this.init();
    }

    protected JucoObjectMapper(ObjectMapper src) {
        super(src);
        this.init();
    }

    public JucoObjectMapper(@Nullable JsonFactory jsonFactory, @Nullable DefaultSerializerProvider serializerProvider, @Nullable DefaultDeserializationContext deserializationContext) {
        super(jsonFactory, serializerProvider, deserializationContext);
        this.init();
    }

    private void init() {
        this.registerModule((Module)new GuavaModule());
        this.registerModule((Module)new JodaModule());
        this.registerModule((Module)new JavaTimeModule());
        this.setPropertyNamingStrategy((PropertyNamingStrategy)new UnderscorePrefixNamingStrategy());
        SimpleModule customModule = new SimpleModule();
        customModule.addSerializer((JsonSerializer)new ItemIdSerializer());
        customModule.addSerializer((JsonSerializer)new StringLiteralSerializer());
        this.addDeserializerForIdType(customModule, GlobalId.class);
        this.addDeserializerForIdType(customModule, ItemId.class);
        this.addDeserializerForIdType(customModule, EntityId.class);
        this.addDeserializerForIdType(customModule, DocumentId.class);
        this.addDeserializerForIdType(customModule, CommentId.class);
        this.addDeserializerForIdType(customModule, ProfileId.class);
        this.addDeserializerForIdType(customModule, TenantId.class);
        this.addDeserializerForIdType(customModule, WorkstreamMessageId.class);
        this.addDeserializerForIdType(customModule, AlbumImageId.class);
        this.addDeserializerForIdType(customModule, LinkId.class);
        this.addDeserializerForIdType(customModule, VideolinkId.class);
        customModule.addSerializer(new LongIdSerializer<NotificationId>(NotificationId.class, IdType.NOTIFICATION_ID));
        customModule.addDeserializer(NotificationId.class, (JsonDeserializer)new NotificationIdDeserializer());
        customModule.addSerializer(new LongIdSerializer<PersonId>(PersonId.class, IdType.PERSON_ID));
        customModule.addDeserializer(PersonId.class, (JsonDeserializer)new PersonIdDeserializer());
        customModule.addSerializer(new LongIdSerializer<ThemeId>(ThemeId.class, IdType.THEME_ID));
        customModule.addSerializer((JsonSerializer)new AppIdSerializer());
        customModule.addDeserializer(AppId.class, (JsonDeserializer)new AppIdDeserializer());
        customModule.addSerializer(PushRegistrationId.class, (JsonSerializer)new PushNotificationDeviceRegistrationIdSerializer());
        customModule.addDeserializer(PushRegistrationId.class, (JsonDeserializer)new PushNotificationDeviceRegistrationIdDeserializer());
        customModule.addKeyDeserializer(ProfileRole.class, (KeyDeserializer)new ProfileRoleKeyDeserializer());
        customModule.addKeySerializer(ProfileRole.class, (JsonSerializer)new ProfileRoleKeySerializer());
        this.addDeserializerForIdType(customModule, TaskId.class);
        customModule.addSerializer((JsonSerializer)new TaskFilterIdSerializer());
        customModule.addDeserializer(TaskFilterId.class, (JsonDeserializer)new TaskFilterIdDeserializer());
        customModule.addSerializer((JsonSerializer)new SectionIdSerializer());
        this.registerModule((Module)customModule);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private <T extends ItemId> void addDeserializerForIdType(SimpleModule module, Class<T> type) {
        module.addDeserializer(type, ItemIdDeserializer.create(type));
    }

    private static final class UnderscorePrefixNamingStrategy
    extends PropertyNamingStrategy.PropertyNamingStrategyBase {
        private static final long serialVersionUID = 1L;

        private UnderscorePrefixNamingStrategy() {
        }

        public String translate(String propertyName) {
            return propertyName.startsWith("_") ? propertyName.substring(1) : propertyName;
        }
    }
}

