/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisDeleteParamBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisInsertParamBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisSelectParamBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisUpdateParamBuilder;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class IbatisStatementBuilder {
    final SqlMapClient _sqlMapClient;
    final String _namespace;
    private final String _jdbcDBType;

    public IbatisStatementBuilder(SqlMapClient sqlMapClient, String namespace, String jdbcDBType) {
        this._sqlMapClient = sqlMapClient;
        this._jdbcDBType = jdbcDBType;
        this._namespace = namespace + ".";
    }

    @Nonnull
    private String appendJdbcDBType(String name) {
        return name + "-" + this._jdbcDBType;
    }

    @Nonnull
    public IbatisUpdateParamBuilder update(String name) {
        return new IbatisUpdateParamBuilder(this, name);
    }

    @Nonnull
    public IbatisUpdateParamBuilder updateDbSpecific(String name) {
        return new IbatisUpdateParamBuilder(this, this.appendJdbcDBType(name));
    }

    @Nonnull
    public <I> IbatisInsertParamBuilder<I> insert(String name) {
        return new IbatisInsertParamBuilder(this, name);
    }

    @Nonnull
    public <I> IbatisInsertParamBuilder<I> insertDbSpecific(String name) {
        return new IbatisInsertParamBuilder(this, this.appendJdbcDBType(name));
    }

    @Nonnull
    public IbatisSelectParamBuilder select(String name) {
        return new IbatisSelectParamBuilder(this, name);
    }

    @Nonnull
    public IbatisSelectParamBuilder selectDbSpecific(String name) {
        return new IbatisSelectParamBuilder(this, this.appendJdbcDBType(name));
    }

    @Nonnull
    public IbatisDeleteParamBuilder delete(String name) {
        return new IbatisDeleteParamBuilder(this, name);
    }

    @Nonnull
    public IbatisDeleteParamBuilder deleteDbSpecific(String name) {
        return new IbatisDeleteParamBuilder(this, this.appendJdbcDBType(name));
    }

    public int batch(BatchCallback callback) {
        try {
            this._sqlMapClient.startBatch();
            callback.execute(this._sqlMapClient);
            return this._sqlMapClient.executeBatch();
        }
        catch (SQLException e) {
            throw new DAOException("batch operation failed", e);
        }
    }

    @FunctionalInterface
    public static interface BatchCallback {
        public void execute(@Nonnull SqlMapClient var1) throws SQLException;
    }
}

