/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisSelectParamBuilder;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IbatisStandardResultBuilder
extends IbatisResultBuilder {
    private final IbatisSelectParamBuilder _builder;
    private final Object _param;

    IbatisStandardResultBuilder(@Nonnull IbatisSelectParamBuilder ibatisQueryBuilder, @Nullable Object param) {
        this._builder = ibatisQueryBuilder;
        this._param = param;
    }

    @Override
    protected void executeWithRowHandler(IbatisDAOUtil.TypedRowHandler<?> rowHandler) {
        try {
            this._builder._sqlMapClient.queryWithRowHandler(this._builder._name, this._param, rowHandler);
        }
        catch (SQLException e) {
            throw new DAOException("select", this._builder._name, e);
        }
    }

    @Nonnull
    public <T> FluentIterable<T> limit(int max) {
        return this.limit(0, max);
    }

    @Nonnull
    public <T> FluentIterable<T> page(int page, int pagesize) {
        return this.limit(page * pagesize, page * pagesize + page);
    }

    @Nonnull
    public <T> FluentIterable<T> sublist(int start, int end) {
        return this.limit(start, end - start);
    }

    @Nonnull
    public <T> FluentIterable<T> limit(int skip, int max) {
        if (max <= 0) {
            return FluentIterable.from((Iterable)ImmutableList.of());
        }
        try {
            List result = this._builder._sqlMapClient.queryForList(this._builder._name, this._param, skip, max);
            return FluentIterable.from((Iterable)result);
        }
        catch (SQLException e) {
            throw new DAOException("select", this._builder._name, e);
        }
    }

    @CheckForNull
    public <T> T singleObject() {
        try {
            Object result = this._builder._sqlMapClient.queryForObject(this._builder._name, this._param);
            return (T)result;
        }
        catch (SQLException e) {
            throw new DAOException("select", this._builder._name, e);
        }
    }
}

