/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class AbstractTypeHandlerCallback<T>
implements TypeHandlerCallback {
    protected final int _sqlType;
    protected final Class<T> _clz;

    protected AbstractTypeHandlerCallback(@Nonnull Class<T> clz, int sqlType) {
        this._clz = clz;
        this._sqlType = sqlType;
    }

    public final void setParameter(ParameterSetter setter, Object parameter) throws SQLException {
        if (parameter == null) {
            setter.setNull(this._sqlType);
        } else {
            if (!this._clz.isAssignableFrom(parameter.getClass())) {
                throw new IllegalArgumentException("Wrong Type supplied: " + parameter.getClass() + " expected " + this._clz);
            }
            Object value = parameter;
            this.setValue(setter, value);
        }
    }

    protected abstract void setValue(@Nonnull ParameterSetter var1, @Nonnull T var2) throws SQLException;

    public final T valueOf(String s) {
        if (s == null) {
            return null;
        }
        try {
            return this.parseValue(s);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @CheckForNull
    protected abstract T parseValue(@Nonnull String var1) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException;

    public final T getResult(ResultGetter getter) throws SQLException {
        try {
            T result = this.getValue(getter);
            if (getter.wasNull()) {
                return null;
            }
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @CheckForNull
    protected abstract T getValue(@Nonnull ResultGetter var1) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, SQLException;
}

