/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.deletion.persistence.ibatis;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.deletion.persistence.ShadowTableDAO;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IbatisShadowTableDAO
implements ShadowTableDAO {
    private static final Logger LOG = LoggerFactory.getLogger(IbatisShadowTableDAO.class);
    private final IbatisStatementBuilder _ibatisStatementBuilder;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisShadowTableDAO(StatementBuilderFactory statementBuilderFactory) {
        this._ibatisStatementBuilder = statementBuilderFactory.ibatistStatementBuilder("ShadowTable");
    }

    @Override
    public ImmutableList<String> getShadowTableNames() {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getShadowTableNames").noParam()).asList();
    }

    @Override
    public DateTime getDeleteBeforeDate(int maxAgeInMinutes) {
        DateTime now = (DateTime)((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getDBTime").noParam()).asOptional().get();
        return now.minusMinutes(maxAgeInMinutes);
    }

    @Override
    public int deleteOldRecords(String tableName, DateTime deleteBeforeDate) {
        if (!tableName.toLowerCase().startsWith("sh_")) {
            LOG.error("deleteOldRecords called with a table name that is not a shadow table!");
            return 0;
        }
        return (Integer)this._ibatisStatementBuilder.delete("deleteOldRecords").param("tableName", tableName, "deleteBeforeDate", deleteBeforeDate);
    }
}

