/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.deletion.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.deletion.model.DeleteActionDescriptor;
import de.justsoftware.onx.common.deletion.model.DeleteActionId;
import de.justsoftware.onx.common.deletion.model.IDeleteAction;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class DeleteAction
implements IDeleteAction {
    private final DeleteActionId _id;
    private final PersonId _personId;
    private final ItemId _itemId;
    private final DeleteActionDescriptor _descriptor;
    private final DateTime _deletedAt;
    private final boolean _archiveData;

    public DeleteAction(DeleteActionId id, PersonId personId, ItemId itemId, DeleteActionDescriptor descriptor, DateTime deletedAt, boolean archiveData) {
        this._id = id;
        this._personId = personId;
        this._itemId = itemId;
        this._descriptor = descriptor;
        this._deletedAt = deletedAt;
        this._archiveData = archiveData;
    }

    public DeleteAction(IDeleteAction origin) {
        this._id = origin.getId();
        this._personId = origin.getPersonId();
        this._itemId = origin.getItemId();
        this._descriptor = origin.getDescriptor();
        this._deletedAt = origin.getDeletedAt();
        this._archiveData = origin.isArchiveData();
    }

    @Override
    public PersonId getPersonId() {
        return this._personId;
    }

    @Override
    public DeleteActionId getId() {
        return this._id;
    }

    @Override
    public ItemId getItemId() {
        return this._itemId;
    }

    @Override
    public DeleteActionDescriptor getDescriptor() {
        return this._descriptor;
    }

    @Override
    public DateTime getDeletedAt() {
        return this._deletedAt;
    }

    @Override
    public boolean isArchiveData() {
        return this._archiveData;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("personId", (Object)this._personId).add("itemId", (Object)this._itemId).add("descriptor", (Object)this._descriptor).add("deletedAt", (Object)this._deletedAt).add("archiveData", this._archiveData).toString();
    }
}

