/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.deletion.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.deletion.business.ShadowTablesDeleteProcess;
import de.justsoftware.onx.common.deletion.persistence.DeleteActionDAO;
import de.justsoftware.onx.common.deletion.persistence.ShadowTableDAO;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.server.business.ClusterConfiguration;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service(value="shadowTablesDeleteProcess")
@ParametersAreNonnullByDefault
public class ShadowTablesDeleteProcessImpl
implements ShadowTablesDeleteProcess {
    private static final Logger LOG = LoggerFactory.getLogger(ShadowTablesDeleteProcessImpl.class);
    private final Settings _settings;
    private final TransactionHelper _transactionHelper;
    private final ShadowTableDAO _shadowTableDAO;
    private final DeleteActionDAO _deleteActionDAO;
    private final ClusterConfiguration _clusterConfiguration;

    @Autowired
    public ShadowTablesDeleteProcessImpl(Settings settings, TransactionHelper transactionHelper, ShadowTableDAO shadowTableDAO, DeleteActionDAO deleteActionDAO, ClusterConfiguration clusterConfiguration) {
        this._settings = settings;
        this._transactionHelper = transactionHelper;
        this._shadowTableDAO = shadowTableDAO;
        this._deleteActionDAO = deleteActionDAO;
        this._clusterConfiguration = clusterConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOldRecords() {
        if (!this._clusterConfiguration.isMaster()) {
            return;
        }
        LOG.info("ShadowTablesDeleteProcess started.");
        Long totalDeleted = 0L;
        try {
            DateTime deleteBeforeDate = this._shadowTableDAO.getDeleteBeforeDate(this._settings.getDataRetentionMinimumTime());
            int numberOfOldDeleteActions = this._deleteActionDAO.getNumberOfRecordsToDelete(deleteBeforeDate);
            if (numberOfOldDeleteActions > 0) {
                ImmutableList<String> shadowTableNames = this._shadowTableDAO.getShadowTableNames();
                totalDeleted = this.deleteRecords(deleteBeforeDate, shadowTableNames);
            }
        }
        finally {
            LOG.info("ShadowTablesDeleteProcess finished. Deleted {} records in total.", (Object)totalDeleted);
        }
    }

    @Nonnull
    private Long deleteRecords(final DateTime deleteBeforeDate, final ImmutableList<String> shadowTableNames) {
        return this._transactionHelper.doInTransaction(new TransactionCallback<Long>(){

            public Long doInTransaction(TransactionStatus status) {
                long deletedSum = 0L;
                for (String shadowTableName : shadowTableNames) {
                    int deleted = ShadowTablesDeleteProcessImpl.this._shadowTableDAO.deleteOldRecords(shadowTableName, deleteBeforeDate);
                    deletedSum += (long)deleted;
                    LOG.debug("Deleted {} records from {}.", (Object)deleted, (Object)shadowTableName);
                }
                int deletedDeleteActions = ShadowTablesDeleteProcessImpl.this._deleteActionDAO.deleteOldRecords(deleteBeforeDate);
                LOG.debug("Deleted {} delete actions.", (Object)deletedDeleteActions);
                return deletedSum;
            }
        });
    }
}

