/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.deletion;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.onx.album.business.AlbumDeletionHandler;
import de.justsoftware.onx.album.business.AlbumImageDeletionHandler;
import de.justsoftware.onx.comments.business.CommentsDeletionHandler;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.deletion.DeletionHandler;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.deletion.TransactionCallbackWithDeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteActionDescriptor;
import de.justsoftware.onx.common.deletion.model.DeleteActionId;
import de.justsoftware.onx.common.deletion.persistence.DeleteActionDAO;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.DriveChangeDeletionHandler;
import de.justsoftware.onx.container.business.EntityDeletionHandler;
import de.justsoftware.onx.container.business.EntityMemberDeletionHandler;
import de.justsoftware.onx.container.business.EntityVersionDeletionHandler;
import de.justsoftware.onx.container.business.ItemDeletionExportHandler;
import de.justsoftware.onx.container.business.impl.EntityRecommendationDeletionHandler;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.business.LikeDeletionHandler;
import de.justsoftware.onx.multiwiki.business.MultiWikiDeletionHandler;
import de.justsoftware.onx.multiwiki.business.MultiWikiVersionDeletionHandler;
import de.justsoftware.onx.person.business.FriendsDeletionHandler;
import de.justsoftware.onx.person.business.PersonDataDeletionHandler;
import de.justsoftware.onx.person.business.PersonDeletionHandler;
import de.justsoftware.onx.person.business.PersonTenantDeletionHandler;
import de.justsoftware.onx.person.business.ProfileComponentsDeletionHandler;
import de.justsoftware.onx.person.business.StartpageItemDeletionHandler;
import de.justsoftware.onx.raweditor.business.RawEditorDeletionHandler;
import de.justsoftware.onx.security.oauth.business.OAuthTokenDeletionHandler;
import de.justsoftware.onx.survey.business.SurveyDeletionHandler;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.videolink.business.VideolinkDeletionHandler;
import de.justsoftware.onx.wikieditor.business.WikiEditorDeletionHandler;
import de.justsoftware.onx.wikieditor.business.WikiEditorVersionDeletionHandler;
import de.justsoftware.onx.workstream.business.WorkstreamMessageDeletionHandler;
import de.justsoftware.onx.workstream.business.WorkstreamReadDeletionHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service
@ParametersAreNonnullByDefault
public class DeletionServiceImpl
implements DeletionService,
CascadeDeleteService {
    @Autowired
    private DeleteActionDAO _deleteActionDAO;
    @Autowired
    private TransactionHelper _transactionHelper;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private EntityDeletionHandler _entityDeletionHandler;
    @Autowired
    private EntityMemberDeletionHandler _entityMemberDeletionHandler;
    @Autowired
    private EntityVersionDeletionHandler _entityVersionDeletionHandler;
    @Autowired
    private VideolinkDeletionHandler _videolinkDeletionHandler;
    @Autowired
    private AlbumImageDeletionHandler _albumImageDeletionHandler;
    @Autowired
    private WorkstreamMessageDeletionHandler _workstreamMessageDeletionHandler;
    @Autowired
    private CommentsDeletionHandler _commentsDeletionHandler;
    @Autowired
    private LikeDeletionHandler _likeDeletionHandler;
    @Autowired
    private StartpageItemDeletionHandler _startpageItemDeletionHandler;
    @Autowired
    private ProfileComponentsDeletionHandler _profileItemDeletionHandler;
    @Autowired
    private AlbumDeletionHandler _albumDeletionHandler;
    @Autowired
    private FriendsDeletionHandler _friendsDeletionHandler;
    @Autowired
    private WikiEditorDeletionHandler _wikiEditorDeletionHandler;
    @Autowired
    private WikiEditorVersionDeletionHandler _wikiEditorVersionDeletionHandler;
    @Autowired
    private RawEditorDeletionHandler _rawEditorDeletionHandler;
    @Autowired
    private MultiWikiVersionDeletionHandler _multiWikiVersionDeletionHandler;
    @Autowired
    private DriveChangeDeletionHandler _driveChangeDeletionHandler;
    @Autowired
    private SurveyDeletionHandler _surveyDeletionHandler;
    @Autowired
    private MultiWikiDeletionHandler _multiWikiDeletionHandler;
    @Autowired
    private PersonDataDeletionHandler _personDataDeletionHandler;
    @Autowired
    private EntityRecommendationDeletionHandler _entityRecommendationDeletionHandler;
    @Autowired
    private WorkstreamReadDeletionHandler _workstreamReadDeletionHandler;
    @Autowired
    private OAuthTokenDeletionHandler _oauthTokenDeletionHandler;
    @Autowired
    private ItemDeletionExportHandler _itemDeletionExportHandler;
    @Autowired
    private PersonDeletionHandler _personDeletionHandler;
    @Autowired
    private PersonTenantDeletionHandler _personTenantDeletionHandler;
    @Autowired
    private Settings _settings;
    private ImmutableList<DeletionHandler> _deletionHandlers;

    @PostConstruct
    public void createDeletionHandlersList() {
        this._deletionHandlers = ImmutableList.builder().add((Object)this._entityDeletionHandler).add((Object)this._entityMemberDeletionHandler).add((Object)this._entityVersionDeletionHandler).add((Object)this._videolinkDeletionHandler).add((Object)this._albumImageDeletionHandler).add((Object)this._workstreamMessageDeletionHandler).add((Object)this._commentsDeletionHandler).add((Object)this._likeDeletionHandler).add((Object)this._startpageItemDeletionHandler).add((Object)this._profileItemDeletionHandler).add((Object)this._albumDeletionHandler).add((Object)this._friendsDeletionHandler).add((Object)this._wikiEditorDeletionHandler).add((Object)this._wikiEditorVersionDeletionHandler).add((Object)this._rawEditorDeletionHandler).add((Object)this._multiWikiVersionDeletionHandler).add((Object)this._driveChangeDeletionHandler).add((Object)this._surveyDeletionHandler).add((Object)this._multiWikiDeletionHandler).add((Object)this._personDataDeletionHandler).add((Object)this._entityRecommendationDeletionHandler).add((Object)this._workstreamReadDeletionHandler).add((Object)this._oauthTokenDeletionHandler).add((Object)this._itemDeletionExportHandler).add((Object)this._personDeletionHandler).add((Object)this._personTenantDeletionHandler).build();
    }

    @Override
    public <T> T deleteInTransactionWithDeleteAction(ItemId itemToDeleteId, PersonId actorId, DeleteActionDescriptor descriptor, TransactionCallbackWithDeleteAction<T> transactionCallback) {
        return this.deleteInternal(itemToDeleteId, actorId, descriptor, (Set<? extends ItemId>)ImmutableSet.of(), transactionCallback);
    }

    @Override
    public <T> T deleteInTransactionWithDeleteAction(ItemId itemToDeleteId, PersonId actorId, Set<? extends ItemId> addionalItemsToCascade, TransactionCallbackWithDeleteAction<T> transactionCallback) {
        return this.deleteInternal(itemToDeleteId, actorId, DeleteActionDescriptor.DEFAULT, addionalItemsToCascade, transactionCallback);
    }

    @Override
    public <T> T deleteInTransactionWithDeleteAction(ItemId itemToDeleteId, PersonId actorId, TransactionCallbackWithDeleteAction<T> transactionCallback) {
        return this.deleteInTransactionWithDeleteAction(itemToDeleteId, actorId, (Set<? extends ItemId>)ImmutableSet.of(), transactionCallback);
    }

    @Nonnull
    private <T> T deleteInternal(final ItemId itemToDeleteId, final PersonId actorId, final DeleteActionDescriptor descriptor, final Set<? extends ItemId> additionalItemsToCascade, final TransactionCallbackWithDeleteAction<T> transactionCallback) {
        TransactionCallback deletionCallback = new TransactionCallback<DeleteTransactionResult<T>>(){

            public DeleteTransactionResult<T> doInTransaction(TransactionStatus status) {
                DeleteAction currentDeleteAction = DeletionServiceImpl.this._deleteActionDAO.getCurrentDeleteAction();
                if (currentDeleteAction == null) {
                    boolean shouldArchive = DeletionServiceImpl.this._settings.getDataRetentionMinimumTime() > 0;
                    DeleteAction deleteAction = DeletionServiceImpl.this.createDeleteAction(itemToDeleteId, actorId, descriptor, shouldArchive);
                    DeletionContextImpl context = new DeletionContextImpl();
                    switch (descriptor) {
                        case DEFAULT: {
                            DeletionServiceImpl.this.cascadeDelete((Set<? extends ItemId>)Sets.union((Set)ImmutableSet.of((Object)itemToDeleteId), (Set)additionalItemsToCascade), context);
                            break;
                        }
                    }
                    Object result = transactionCallback.doInTransactionWithDeleteAction(status, deleteAction);
                    if (shouldArchive) {
                        DeletionServiceImpl.this._deleteActionDAO.markDeleteActionAsFinished(deleteAction.getId());
                    } else {
                        DeletionServiceImpl.this._deleteActionDAO.delete(deleteAction.getId());
                    }
                    return new DeleteTransactionResult(context.getServerEvents(), context.getDeleteTransactionCallbacks(), result);
                }
                Object result = transactionCallback.doInTransactionWithDeleteAction(status, currentDeleteAction);
                return new DeleteTransactionResult(result);
            }
        };
        DeleteTransactionResult transactionResult = (DeleteTransactionResult)this._transactionHelper.doInTransaction(deletionCallback);
        for (DeleteTransactionCallback callback : transactionResult._callbacks) {
            callback.afterCommit();
        }
        for (ServerEvent event : transactionResult.getEvents()) {
            this._eventBus.post(event);
        }
        return transactionResult.getResult();
    }

    @Nonnull
    private DeleteAction createDeleteAction(ItemId itemToDeleteId, PersonId actorId, DeleteActionDescriptor descriptor, boolean shouldArchive) {
        DeleteActionId deleteActionId = this._deleteActionDAO.create(itemToDeleteId, actorId, descriptor, shouldArchive);
        DeleteAction deleteAction = this._deleteActionDAO.getById(deleteActionId);
        if (deleteAction == null) {
            throw new ServiceException("Could not create new delete action");
        }
        return deleteAction;
    }

    @Override
    public void cascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        if (!parentIds.isEmpty()) {
            deletionContext.addDeletedItems(parentIds);
            for (DeletionHandler handler : this._deletionHandlers) {
                handler.handleCascadeDelete(parentIds, deletionContext);
            }
        }
    }

    private static final class DeletionContextImpl
    implements DeletionContext {
        private final ImmutableList.Builder<ServerEvent> _serverEvents = ImmutableList.builder();
        private final ImmutableList.Builder<DeleteTransactionCallback> _callbacks = ImmutableList.builder();
        private final HashSet<ItemId> _deletedItems = new HashSet();
        private final Predicate<ItemId> _notYetDeletedPredicate = new NullIsFalsePredicate<ItemId>(){

            @Override
            protected boolean applySafe(ItemId input) {
                return !this.isItemDeleted(input);
            }
        };

        private DeletionContextImpl() {
        }

        @Nonnull
        ImmutableList<ServerEvent> getServerEvents() {
            return this._serverEvents.build();
        }

        @Nonnull
        ImmutableList<DeleteTransactionCallback> getDeleteTransactionCallbacks() {
            return this._callbacks.build();
        }

        @Override
        public void addServerEvent(ServerEvent serverEvent) {
            this._serverEvents.add((Object)serverEvent);
        }

        @Override
        public void addDeletedItem(ItemId globalId) {
            this._deletedItems.add(globalId);
        }

        @Override
        public void addDeletedItems(Iterable<? extends ItemId> globalIds) {
            this._deletedItems.addAll((Collection<ItemId>)ImmutableSet.copyOf(globalIds));
        }

        @Override
        public boolean isItemDeleted(ItemId globalId) {
            return this._deletedItems.contains(globalId);
        }

        @Override
        public <T extends ItemId> ImmutableSet<T> filterItemsNotYetDeleted(Iterable<T> globalIds) {
            return FluentIterable.from(globalIds).filter(this._notYetDeletedPredicate).toSet();
        }

        @Override
        public void attach(DeleteTransactionCallback callback) {
            this._callbacks.add((Object)callback);
        }

        @Override
        public Predicate<ItemId> notYetDeletedPredicate() {
            return this._notYetDeletedPredicate;
        }
    }

    private static final class DeleteTransactionResult<T> {
        private final ImmutableList<ServerEvent> _events;
        private final ImmutableList<DeleteTransactionCallback> _callbacks;
        private final T _result;

        public DeleteTransactionResult(@Nonnull T result) {
            this((ImmutableList<ServerEvent>)ImmutableList.of(), (ImmutableList<DeleteTransactionCallback>)ImmutableList.of(), result);
        }

        public DeleteTransactionResult(@Nonnull ImmutableList<ServerEvent> events, @Nonnull ImmutableList<DeleteTransactionCallback> callbacks, @Nonnull T result) {
            this._events = events;
            this._callbacks = callbacks;
            this._result = result;
        }

        @Nonnull
        public ImmutableList<ServerEvent> getEvents() {
            return this._events;
        }

        @Nonnull
        public T getResult() {
            return this._result;
        }

        @Nonnull
        public ImmutableList<DeleteTransactionCallback> getDeleteTransactionCallbacks() {
            return this._callbacks;
        }
    }
}

