/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import de.justsoftware.onx.common.cache.AbstractMultiMapCacheAccessor;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class UniDirectionalCacheAccessor<C extends CacheName, I, O>
extends AbstractMultiMapCacheAccessor<C, I, O, Map.Entry<? extends I, ? extends O>, ImmutableSetMultimap<I, O>, ImmutableSetMultimap.Builder<I, O>, ImmutableSet<O>> {
    private final Function<? super I, String> _keyFunction;
    private final Function<? super Set<? extends I>, ? extends Multimap<? extends I, ? extends O>> _databaseOperation;

    public UniDirectionalCacheAccessor(CacheClient<? super C> cache, C name, Function<? super Set<? extends I>, ? extends Multimap<? extends I, ? extends O>> databaseOperation, Function<? super I, String> keyFunction) {
        super(cache, name);
        this._databaseOperation = databaseOperation;
        this._keyFunction = keyFunction;
    }

    @Override
    protected final ImmutableSet<O> get(ImmutableSetMultimap<I, O> map, I input) {
        return map.get(input);
    }

    @Override
    protected final ImmutableSetMultimap<I, O> build(ImmutableSetMultimap.Builder<I, O> builder) {
        return builder.build();
    }

    @Override
    protected final ImmutableSetMultimap.Builder<I, O> createBuilder() {
        return ImmutableSetMultimap.builder();
    }

    @Override
    protected final I objectToKey(Map.Entry<? extends I, ? extends O> dbResult) {
        return dbResult.getKey();
    }

    @Override
    protected final O objectToValue(Map.Entry<? extends I, ? extends O> dbResult) {
        return dbResult.getValue();
    }

    @Override
    protected final Iterable<? extends Map.Entry<? extends I, ? extends O>> getListFromDatabase(Set<? extends I> inputs) {
        return this.getMultimapFromDatabase(inputs).entries();
    }

    @Nonnull
    protected Multimap<? extends I, ? extends O> getMultimapFromDatabase(Set<? extends I> inputs) {
        return (Multimap)Preconditions.checkNotNull((Object)((Multimap)this._databaseOperation.apply(inputs)));
    }

    @Override
    protected String keyToString(I key) {
        return (String)Preconditions.checkNotNull((Object)((String)this._keyFunction.apply(key)));
    }
}

