/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import de.justsoftware.onx.common.cache.NonCachingSingleValueCache;
import de.justsoftware.onx.common.cache.SingleValueCache;
import de.justsoftware.onx.common.cache.SingleValueWarmedUpCache;
import de.justsoftware.onx.common.cache.SingleValueWarmedUpCacheFactory;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SingleValueWarmedUpCacheFactoryImpl
implements SingleValueWarmedUpCacheFactory,
DisposableBean {
    private final boolean _warmupCacheActivated;
    private final List<SingleValueWarmedUpCache<?>> _singleValueWarmedUpCaches;

    @Autowired
    public SingleValueWarmedUpCacheFactoryImpl(@Value(value="${cache.warmupcache.activated:true}") boolean warmupCacheActivated) {
        this._warmupCacheActivated = warmupCacheActivated;
        this._singleValueWarmedUpCaches = Lists.newArrayList();
    }

    @Override
    public <T> SingleValueCache<T> create(String threadName, long pollingInterval, Supplier<T> supplier) {
        return this._warmupCacheActivated ? this.createAndAddSingleValueWarmedUpCache(threadName, pollingInterval, supplier) : new NonCachingSingleValueCache<T>(supplier);
    }

    @Nonnull
    private <T> SingleValueWarmedUpCache<T> createAndAddSingleValueWarmedUpCache(String threadName, long pollingInterval, Supplier<T> supplier) {
        SingleValueWarmedUpCache<T> result = new SingleValueWarmedUpCache<T>(threadName, pollingInterval, supplier);
        this._singleValueWarmedUpCaches.add(result);
        return result;
    }

    public void destroy() throws Exception {
        for (SingleValueWarmedUpCache<?> cache : this._singleValueWarmedUpCaches) {
            cache.destroy();
        }
    }
}

