/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.justsoftware.onx.common.cache.SingleValueCache;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleValueWarmedUpCache<T>
implements SingleValueCache<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleValueWarmedUpCache.class);
    private final Supplier<T> _supplier;
    private volatile T _value;
    private final AtomicBoolean _valueIsInvalid = new AtomicBoolean(false);
    private final ScheduledExecutorService _executorService;
    private final Runnable _createValueRunnable = new Runnable(){

        @Override
        public void run() {
            if (SingleValueWarmedUpCache.this._valueIsInvalid.getAndSet(false)) {
                try {
                    SingleValueWarmedUpCache.this._value = SingleValueWarmedUpCache.this._supplier.get();
                }
                catch (RuntimeException e) {
                    LOG.error("Error while calculating value", (Throwable)e);
                }
            }
        }
    };

    SingleValueWarmedUpCache(@Nonnull String threadName, long pollingInterval, @Nonnull Supplier<T> supplier) {
        this._supplier = supplier;
        this._value = this._supplier.get();
        this._executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(threadName + "-%d").build());
        this._executorService.scheduleWithFixedDelay(this._createValueRunnable, pollingInterval, pollingInterval, TimeUnit.MILLISECONDS);
    }

    public T get() {
        return this._value;
    }

    @Override
    public void invalidate() {
        this._valueIsInvalid.set(true);
    }

    public void destroy() {
        if (!this._executorService.isShutdown() && !this._executorService.isTerminated()) {
            this._executorService.shutdown();
        }
    }
}

