/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.cache.AbstractCacheAccessor;
import de.justsoftware.onx.common.cache.SingleValueCacheAccessor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

abstract class AbstractSingleValueCacheAccessor<C extends CacheName, I, O>
extends AbstractCacheAccessor<C, I, O>
implements SingleValueCacheAccessor<I, O> {
    @ParametersAreNonnullByDefault
    AbstractSingleValueCacheAccessor(CacheClient<? super C> cache, C name) {
        super(cache, name);
    }

    @Nonnull
    protected final O castAndCopy(@Nonnull Object cachedResult) {
        Object casted = cachedResult;
        return (O)this.copyObject(casted);
    }

    @Nonnull
    protected O copyObject(@Nonnull O o) {
        return o;
    }

    protected final void putIntoCache(@Nonnull I input, @Nullable O value) {
        this._cache.add(this._name, this.keyToString(input), value != null ? this.copyObject(value) : CacheClient.NULL);
    }

    @Override
    public final ImmutableList<O> getList(Iterable<? extends I> inputs) {
        ImmutableMap mapResults = this.getMap(ImmutableSet.copyOf(inputs));
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (I i : inputs) {
            Object mapResult = mapResults.get(i);
            if (mapResult == null) continue;
            resultBuilder.add(mapResult);
        }
        return resultBuilder.build();
    }
}

