/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.common.shared.model.ServiceException;
import de.justsoftware.onx.common.cache.SingleValueCache;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

public abstract class AbstractSingleValueCache<C extends CacheName, T>
implements SingleValueCache<T> {
    private C _cachename;
    private String _key;
    private CacheClient<? super C> _cache;

    protected AbstractSingleValueCache(@Nonnull CacheClient<? super C> cache, @Nonnull C cachename, @Nonnull String key) {
        this._cache = cache;
        this._cachename = cachename;
        this._key = key;
    }

    protected AbstractSingleValueCache(@Nonnull CacheClient<? super C> cache, @Nonnull C cachename) {
        this(cache, (C)cachename, "");
    }

    @Nonnull
    public T get() {
        Object res = this._cache.get(this._cachename, this._key);
        if (res != null) {
            return res;
        }
        T fromDb = this.getFromDatabase();
        this._cache.add(this._cachename, this._key, fromDb);
        return fromDb;
    }

    @Nonnull
    protected abstract T getFromDatabase();

    @Override
    public void invalidate() {
        try {
            this._cache.delete(this._cachename, this._key).get();
        }
        catch (InterruptedException e) {
            return;
        }
        catch (ExecutionException e) {
            throw new ServiceException(e);
        }
    }
}

