/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheName;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.cache.AbstractSingleValueCacheAccessor;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractSingleLoadingCacheAccessor<C extends CacheName, I, O>
extends AbstractSingleValueCacheAccessor<C, I, O> {
    protected AbstractSingleLoadingCacheAccessor(CacheClient<? super C> cache, C name) {
        super(cache, name);
    }

    @Override
    public final O getSingle(I input) {
        Object result = this._cache.get(this._name, this.keyToString(input));
        if (CacheClient.NullValue.INSTANCE == result) {
            return null;
        }
        if (result != null) {
            return this.castAndCopy(result);
        }
        O newResult = this.getFromDatabaseSingle(input);
        this.putIntoCache(input, newResult);
        return newResult != null ? (O)this.copyObject(newResult) : null;
    }

    @Override
    public ImmutableMap<I, O> getMap(Set<? extends I> inputs) {
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (I i : inputs) {
            O o = this.getSingle(i);
            if (o == null) continue;
            resultBuilder.put(i, o);
        }
        return resultBuilder.build();
    }

    @CheckForNull
    protected abstract O getFromDatabaseSingle(I var1);

    @Nonnull
    public static <C extends CacheName, I, O> AbstractSingleLoadingCacheAccessor<C, I, O> create(CacheClient<? super C> cache, C name, final Function<? super I, ? extends O> databaseOperation, final Function<? super I, String> keyFunction) {
        return new AbstractSingleLoadingCacheAccessor<C, I, O>(cache, name){

            @Override
            protected O getFromDatabaseSingle(I input) {
                return databaseOperation.apply(input);
            }

            @Override
            protected String keyToString(I key) {
                return (String)keyFunction.apply(key);
            }
        };
    }
}

