/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheName;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import de.justsoftware.onx.common.cache.AbstractMapLoadingCacheAccessor;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class AbstractRelationalCacheAccessor<C extends CacheName, L, R, O>
extends AbstractMapLoadingCacheAccessor<C, Map.Entry<? extends L, ? extends R>, O> {
    protected AbstractRelationalCacheAccessor(@Nonnull CacheClient<? super C> cache, @Nonnull C name) {
        super(cache, name);
    }

    @Override
    protected final String keyToString(Map.Entry<? extends L, ? extends R> key) {
        return this.keyToString(key.getKey(), key.getValue());
    }

    @Nonnull
    protected abstract String keyToString(@Nonnull L var1, @Nonnull R var2);

    @Override
    protected final Map<? extends Map.Entry<L, R>, ? extends O> getFromDatabaseMulti(Set<? extends Map.Entry<? extends L, ? extends R>> inputs) {
        ImmutableMap.Builder resultMap = ImmutableMap.builder();
        for (Table.Cell cell : this.getFromDatabase(ImmutableSetMultimap.copyOf(inputs)).cellSet()) {
            resultMap.put((Object)Maps.immutableEntry((Object)cell.getRowKey(), (Object)cell.getColumnKey()), cell.getValue());
        }
        return resultMap.build();
    }

    @Nonnull
    public final ImmutableTable<L, R, O> getTable(@Nonnull SetMultimap<? extends L, ? extends R> param) {
        ImmutableTable.Builder result = ImmutableTable.builder();
        for (Map.Entry entry : this.getMap(param.entries()).entrySet()) {
            result.put(((Map.Entry)entry.getKey()).getKey(), ((Map.Entry)entry.getKey()).getValue(), entry.getValue());
        }
        return result.build();
    }

    @Nonnull
    protected abstract Table<? extends L, ? extends R, ? extends O> getFromDatabase(@Nonnull ImmutableSetMultimap<L, R> var1);

    @Nonnull
    public final Future<Boolean> invalidateKey(@Nonnull L left, @Nonnull R right) {
        return this.invalidateKey(Maps.immutableEntry(left, right));
    }

    @CheckForNull
    public final O getSingle(@Nonnull L left, @Nonnull R right) {
        return this.getSingle(Maps.immutableEntry(left, right));
    }
}

