/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheName;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.cache.AbstractSingleValueCacheAccessor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class AbstractMapLoadingCacheAccessor<C extends CacheName, I, O>
extends AbstractSingleValueCacheAccessor<C, I, O> {
    protected AbstractMapLoadingCacheAccessor(@Nonnull CacheClient<? super C> cache, @Nonnull C name) {
        super(cache, name);
    }

    @Override
    public final ImmutableMap<I, O> getMap(Set<? extends I> inputs) {
        if (this.isPassThrough(inputs)) {
            return ImmutableMap.copyOf(this.getFromDatabaseMulti(inputs));
        }
        Map cacheResults = this._cache.getBulk(this._name, (Collection<String>)this.createKeys(inputs));
        ImmutableMap.Builder result = ImmutableMap.builder();
        ImmutableSet.Builder missingKeysBuilder = ImmutableSet.builder();
        for (I input : inputs) {
            String key = this.keyToString(input);
            Object cachedResult = cacheResults.get(key);
            if (cachedResult == null) {
                missingKeysBuilder.add(input);
                continue;
            }
            if (CacheClient.NULL.equals(cachedResult)) continue;
            result.put(input, this.castAndCopy(cachedResult));
        }
        ImmutableSet missingKeys = missingKeysBuilder.build();
        if (!missingKeys.isEmpty()) {
            Map<I, O> dbResults = this.getFromDatabaseMulti((Set<? extends I>)missingKeys);
            for (Object input : missingKeys) {
                O dbResult = dbResults.get(input);
                this.putIntoCache(input, dbResult);
                if (dbResult == null) continue;
                result.put(input, this.copyObject(dbResult));
            }
        }
        return result.build();
    }

    @Override
    public final O getSingle(I input) {
        return (O)this.getMap((Set<? extends I>)ImmutableSet.of(input)).get(input);
    }

    @Nonnull
    protected abstract Map<? extends I, ? extends O> getFromDatabaseMulti(@Nonnull Set<? extends I> var1);
}

