/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.impl;

import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.event.SuperopertyChangeEvent;
import com.freiheit.superoperty.event.SuperopertyChangeListener;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.business.impl.SuperopertyJobTriggerBean;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

@ParametersAreNonnullByDefault
public class SuperopertyRescheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuperopertyRescheduler.class);
    private Scheduler _scheduler;
    private List<CronTrigger> _triggers;

    @Required
    public void setScheduler(Scheduler scheduler) {
        this._scheduler = scheduler;
    }

    @Required
    public void setTriggers(List<CronTrigger> triggers) {
        this._triggers = triggers;
    }

    @Required
    public void setCronExpressionProperty(Property prop) {
        prop.addSuperopertyChangeListener(new SuperopertyChangeListener(){

            public void superopertyChange(SuperopertyChangeEvent ev) {
                LOGGER.debug("rescheduling jobs for " + SuperopertyRescheduler.this._triggers.size() + " triggers");
                try {
                    CronExpression cronExpression = new CronExpression(SuperopertyJobTriggerBean.emptyStringToCronExpr(ev.getNewStringValue()));
                    for (CronTrigger trigger : SuperopertyRescheduler.this._triggers) {
                        CronTrigger updatedTrigger = (CronTrigger)trigger.getTriggerBuilder().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).build();
                        Date nextFireTime = SuperopertyRescheduler.this._scheduler.rescheduleJob(updatedTrigger.getKey(), (Trigger)updatedTrigger);
                        if (nextFireTime != null) {
                            LOGGER.debug("next fire time for " + updatedTrigger.getKey() + ": " + nextFireTime.getTime());
                            continue;
                        }
                        LOGGER.error("Error rescheduling job, original job not found.");
                    }
                }
                catch (SchedulerException e) {
                    LOGGER.error("Error rescheduling job", (Throwable)e);
                }
                catch (ParseException e) {
                    LOGGER.error("Error setting new cron expression", (Throwable)e);
                }
            }
        });
    }

    public void setTrigger(CronTrigger trigger) {
        this.setTriggers((List<CronTrigger>)ImmutableList.of((Object)trigger));
    }
}

