/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.impl;

import de.justsoftware.onx.common.business.StorageServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class StorageServerConfigImpl
implements StorageServerConfig {
    private final String _storageServerUrl;
    private final boolean _trashFiles;

    @Autowired
    public StorageServerConfigImpl(@Value(value="${storageserver.url}") String storageServerUrl, @Value(value="${storageserver.trashFiles}") boolean trashFiles) {
        this._storageServerUrl = storageServerUrl;
        this._trashFiles = trashFiles;
    }

    @Override
    public boolean isTrashEnabled() {
        return this._trashFiles;
    }

    @Override
    public String getStorageServerUrl() {
        return this._storageServerUrl;
    }

    @Override
    public String getUrlWithPath(String path) {
        return this._storageServerUrl + path;
    }
}

