/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.impl;

import de.justsoftware.onx.common.business.ServerUrlUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="serverUrlUtil")
public class ServerUrlUtilImpl
implements ServerUrlUtil,
InitializingBean {
    @Value(value="${staticresourceprefix}")
    private String _staticResourcePrefix;
    @Value(value="${dynamicresourceprefix}")
    private String _dynamicResourcePrefix;
    @Value(value="${commonresourceprefix}")
    private String _commonResourcePrefix;
    @Value(value="${port}")
    private int _systemPort;
    @Value(value="${protocol}")
    private String _systemProtocol;
    @Value(value="${domain}")
    private String _systemDomain;
    private String _prefix;
    private String _htmlClientBaseUrl;

    public void afterPropertiesSet() {
        this._prefix = this.createUrl(this._systemDomain, this._systemProtocol, this.getSystemPortOrEmpty());
        this._htmlClientBaseUrl = StringUtils.removeEnd((String)this.getDynamicResourcePrefixWithSystemDomain(), (String)"/") + "/html";
    }

    @Nonnull
    private String createUrl(@Nullable String domain, @Nonnull String protocol, @Nonnull String portSuffix) {
        if (StringUtils.isBlank((String)domain)) {
            return "";
        }
        return protocol + "://" + domain + portSuffix;
    }

    @Override
    public String getStaticResourcePrefix() {
        return this._staticResourcePrefix;
    }

    @Override
    public String getDynamicResourcePrefix() {
        return this._dynamicResourcePrefix;
    }

    @Override
    public String getCommonResourcePrefix() {
        return this._commonResourcePrefix;
    }

    @Override
    public String getSystemDomain() {
        return this._systemDomain;
    }

    @Override
    public int getSystemPort() {
        return this._systemPort;
    }

    @Override
    public String getSystemPortOrEmpty() {
        return this._systemPort != 80 && this._systemPort != 443 ? ":" + this._systemPort : "";
    }

    @Override
    public String getDynamicResourcePrefixWithSystemDomain() {
        return this._prefix + this._dynamicResourcePrefix;
    }

    @Override
    public String getSystemDomainPrefix() {
        return this._prefix;
    }

    @Override
    public String getSystemDomainWithPath(String path) {
        return this._prefix + path;
    }

    @Override
    public String getSystemProtocol() {
        return this._systemProtocol;
    }

    @Override
    public String getHtmlClientBaseUrl() {
        return this._htmlClientBaseUrl;
    }
}

