/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.freiheit.toro.common.shared.i18n.FooterpagesConstants;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.I18nextService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.rest.JucoObjectMapper;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.i18n.EntityTranslationUtil;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicEntityAttributesMessages;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.SelectOptionMessage;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.server.util.Filenames;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.i18n.EntityStatusMessages;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.attributes.i18n.Language;
import de.justsoftware.onx.person.business.attributes.i18n.MultiLangBook;
import de.justsoftware.onx.profile.business.ProfileReadWriteDataService;
import de.justsoftware.onx.profile.business.ProfileService;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributeSearchType;
import de.justsoftware.onx.profile.model.ProfileAttributeType;
import de.justsoftware.onx.profile.model.ProfileAttributesConfiguration;
import de.justsoftware.onx.profile.model.ProfileSectionConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class I18nextServiceImpl
implements I18nextService {
    private static final Logger LOG = LoggerFactory.getLogger(I18nextServiceImpl.class);
    private static final String CONNECT_PERSON_ROLES = "connect-person-roles";
    private static final String CONNECT_ENTITY_ATTRIBUTES = "connect-entity-attributes";
    private static final String CONNECT_ENTITY_STATUS = "connect-entity-status";
    private static final String SEARCH_FILTERS = "search-filters";
    private static final String PROFILE_ATTRIBUTES_DEFAULT = "profile-attributes-default";
    @Autowired
    private JucoObjectMapper _jucoObjectMapper;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private ProfileService _profileService;
    @Autowired
    private ProfileReadWriteDataService _profileReadWriteDataService;
    @Value(value="${i18n.json.path}")
    private String _localesPath;

    @Nonnull
    private Map<String, Object> entityDynamicAttributesTranslation(Language language) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ImmutableSet<EntityType> entities = this._entityConfigService.getOrderedActivatedEntityTypes();
        for (EntityType type : entities) {
            ImmutableList<DynamicAttributeConfig> attributes = this._entityConfigService.getDynamicAttributesForType(type);
            if (attributes.isEmpty()) continue;
            for (DynamicAttributeConfig attribute : attributes) {
                SelectionInput selection;
                DynamicAttributeId id = attribute.getId();
                String dimension = EntityTranslationUtil.getEntityTypeAttributesKeyPart(type, id);
                result.put(id.getId() + "_" + type.getName(), this._i18nService.createProxy(DynamicEntityAttributesMessages.class, dimension, language.toString()).name(id));
                Input input = attribute.getInput();
                if (!(input instanceof SelectionInput) || (selection = (SelectionInput)input).getValues().isEmpty()) continue;
                ImmutableMap.Builder selectBuilder = ImmutableMap.builder();
                Object previousValues = result.get(id.getId());
                if (previousValues instanceof Map) {
                    selectBuilder.putAll((Map)previousValues);
                }
                for (String value : selection.getValues()) {
                    selectBuilder.put((Object)(value + "_" + type.getName()), (Object)this._i18nService.createProxy(SelectOptionMessage.class, EntityTranslationUtil.getDynamicOptionTranslationKey(type, id, value), language.toString()).name(value));
                }
                result.put(id.getId(), selectBuilder.build());
            }
        }
        return result;
    }

    @Nonnull
    private Map<String, Object> rolesTranslation(Language language) {
        ImmutableMap.Builder translatedTerms = ImmutableMap.builder();
        MultiLangBook rolesTranslation = this._personService.getRolesTranslation();
        for (String term : rolesTranslation.getAllTerms()) {
            translatedTerms.put((Object)term, (Object)rolesTranslation.getI18n(term).getFor(language));
        }
        return translatedTerms.build();
    }

    @Nonnull
    private Map<String, Object> entityStatusTranslation(Language language) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        ImmutableSet<EntityType> entityTypes = this._entityConfigService.getOrderedActivatedEntityTypes();
        for (EntityType type : entityTypes) {
            ImmutableSet<EntityStatus> status = this._entityConfigService.getAvailableEntityStatus(type);
            for (EntityStatus stat : status) {
                String dimension = EntityTranslationUtil.getEntityTypeStatusKeyPart(type, stat);
                EntityStatusMessages statusMessages = this._i18nService.createProxy(EntityStatusMessages.class, dimension, language.toString());
                String key = stat.getName() + "_" + type.getName();
                result.put((Object)key, (Object)statusMessages.name(stat.getName()));
            }
        }
        return result.build();
    }

    @Nonnull
    private Map<String, Object> footerpagesTranslation(Language language) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        FooterpagesConstants constants = this._i18nService.createProxy(FooterpagesConstants.class, language.toString());
        result.put((Object)"terms", (Object)constants.agb());
        result.put((Object)"privacy", (Object)constants.datenschutz());
        result.put((Object)"imprint", (Object)constants.impressum());
        result.put((Object)"help", (Object)constants.hilfe());
        result.put((Object)"press", (Object)constants.presse());
        result.put((Object)"about", (Object)constants.uebertoro());
        result.put((Object)"articlesOfAssociation", (Object)constants.articlesOfAssociation());
        return result.build();
    }

    @Nonnull
    private Map<String, Object> termsTranslation(Language language) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        BasicConstants constants = this._i18nService.createProxy(BasicConstants.class, language.toString());
        result.put((Object)"termsHeader", (Object)constants.legalAgreementHeader());
        result.put((Object)"termsText", (Object)constants.legalAgreementText());
        return result.build();
    }

    @Override
    public String getTranslationAsJavaScript(List<String> languages, List<String> namespaces, boolean mergeNamespace, String varName, boolean addDefaultWording) throws JsonProcessingException {
        Map<String, Object> translation = this.getTranslation(languages, namespaces, mergeNamespace, addDefaultWording);
        return "var " + varName + " = " + this._jucoObjectMapper.writeValueAsString(translation) + ";";
    }

    @Override
    public Map<String, Object> getTranslation(List<String> languages, List<String> namespaces, boolean mergeNamespace, boolean addDefaultWording) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (namespaces.isEmpty() || languages.isEmpty()) {
            return result;
        }
        String mainNamespace = namespaces.get(0);
        for (String language : languages) {
            String mainLocale = I18nextServiceImpl.getMainLocale(language);
            Language lng = (Language)Language.FROM_STRING.apply((Object)mainLocale);
            if (lng == null) continue;
            HashBasedTable translationNamespaces = HashBasedTable.create();
            for (String namespace : ImmutableList.copyOf(namespaces).reverse()) {
                this.addNamespace((HashBasedTable<String, String, Object>)translationNamespaces, lng, namespace, mainNamespace, mergeNamespace, addDefaultWording);
            }
            result.put(mainLocale, translationNamespaces.rowMap());
        }
        return result;
    }

    @Override
    public ImmutableSet<Language> getAvailableLanguages() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String language : this._i18nService.getAvailableLanguages()) {
            builder.add((Object)((Language)Language.FROM_STRING.apply((Object)I18nextServiceImpl.getMainLocale(language))));
        }
        return builder.build();
    }

    @Override
    public void updateJsonTranslationForNamespace(Table<Language, String, Object> translations, String namespace) throws IOException {
        File localesPath = this.getJsonLocalesDirectory();
        if (localesPath.exists() || localesPath.mkdirs()) {
            for (Map.Entry entry : translations.rowMap().entrySet()) {
                String jsonFileName = this.getJsonFileName(namespace, (Language)entry.getKey());
                Map<String, Object> translation = this.readJsonFromFile(jsonFileName);
                I18nextServiceImpl.mergeIntoDestination((Map)entry.getValue(), translation);
                this._jucoObjectMapper.writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValue(this.getJsonFile(jsonFileName), translation);
            }
        } else {
            throw new FileNotFoundException("i18n - can't create custom locales directory: " + localesPath.getAbsolutePath());
        }
    }

    private void addNamespace(HashBasedTable<String, String, Object> destination, Language language, String namespace, String mainNamespace, boolean mergeNamespace, boolean addDefaultWording) {
        String usedNamespace;
        String string = usedNamespace = mergeNamespace ? mainNamespace : namespace;
        if (addDefaultWording && namespace.equals(mainNamespace)) {
            ImmutableMap.Builder dynamicTranslationBuilder = ImmutableMap.builder();
            dynamicTranslationBuilder.put((Object)"entity", this.entityDynamicAttributesTranslation(language));
            destination.put((Object)usedNamespace, (Object)"dynamicAttributes", (Object)dynamicTranslationBuilder.build());
            destination.put((Object)usedNamespace, (Object)"roles", this.rolesTranslation(language));
            destination.put((Object)usedNamespace, (Object)"footerPages", this.footerpagesTranslation(language));
            destination.put((Object)usedNamespace, (Object)"terms", this.termsTranslation(language));
        }
        this.addConnectWording(destination, language, namespace, usedNamespace);
        this.addJsonResources(namespace, language, destination.row((Object)usedNamespace));
    }

    private void addJsonResources(String namespace, Language language, Map<String, Object> destination) {
        String jsonFileName = this.getJsonFileName(namespace, language);
        I18nextServiceImpl.mergeIntoDestination(this.readJsonFromClasspath("locales/fallback", jsonFileName), destination);
        I18nextServiceImpl.mergeIntoDestination(this.readJsonFromClasspath("locales", jsonFileName), destination);
        I18nextServiceImpl.mergeIntoDestination(this.readJsonFromFile(jsonFileName), destination);
    }

    @Override
    public ImmutableList<URL> getResourceURLs(List<String> namespaces) {
        ArrayList<URL> optionalResultList = new ArrayList<URL>();
        for (String namespace : namespaces) {
            for (Language language : this.getAvailableLanguages()) {
                String jsonFileName = this.getJsonFileName(namespace, language);
                optionalResultList.add(this.getJsonClasspathResourceURL("locales/fallback", jsonFileName));
                optionalResultList.add(this.getJsonClasspathResourceURL("locales", jsonFileName));
                optionalResultList.add(this.getJsonFileResourceURL(jsonFileName));
            }
        }
        return (ImmutableList)optionalResultList.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private File getJsonLocalesDirectory() {
        return new File(Filenames.replaceTildeByUserHome(this._localesPath));
    }

    @Nonnull
    private String getJsonFileName(String namespace, Language language) {
        return namespace + "_" + language + ".json";
    }

    @Nonnull
    private File getJsonFile(String jsonFileName) {
        return new File(this.getJsonLocalesDirectory(), jsonFileName);
    }

    @CheckForNull
    private URL getJsonFileResourceURL(String jsonFileName) {
        try {
            return this.getJsonFile(jsonFileName).toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOG.error("file url of " + jsonFileName + " is invalid", (Throwable)e);
            return null;
        }
    }

    @CheckForNull
    private URL getJsonClasspathResourceURL(String path, String jsonFileName) {
        String resourceName = path + "/" + jsonFileName;
        return this.getClass().getClassLoader().getResource(resourceName);
    }

    @Nonnull
    private Map<String, Object> readJsonFromFile(String jsonFileName) {
        File jsonFile = this.getJsonFile(jsonFileName);
        if (!jsonFile.exists()) {
            LOG.debug("i18n file:" + jsonFile.getAbsolutePath() + " not found!");
        } else if (!jsonFile.isFile()) {
            LOG.debug("i18n file:" + jsonFile.getAbsolutePath() + " is no file!");
        } else if (!jsonFile.canRead()) {
            LOG.debug("i18n file:" + jsonFile.getAbsolutePath() + " is not readable!");
        } else {
            try {
                return (Map)this._jucoObjectMapper.readValue(jsonFile, Map.class);
            }
            catch (JsonProcessingException e) {
                LOG.error("i18n file:" + jsonFile.getAbsolutePath() + " has unreadable content!", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn("i18n file:" + jsonFile.getAbsolutePath() + " can't be loaded!", (Throwable)e);
            }
        }
        return Maps.newHashMap();
    }

    @Nonnull
    private Map<String, Object> readJsonFromClasspath(String path, String jsonFileName) {
        URL jsonResource = this.getJsonClasspathResourceURL(path, jsonFileName);
        try {
            if (jsonResource != null) {
                return (Map)this._jucoObjectMapper.readValue(jsonResource, Map.class);
            }
        }
        catch (JsonProcessingException e) {
            LOG.error("i18n classpath resource:" + path + "/" + jsonFileName + " has unreadable content!", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("i18n classpath resource:" + path + "/" + jsonFileName + " can't be loaded!", (Throwable)e);
        }
        return Maps.newHashMap();
    }

    private void addConnectWording(HashBasedTable<String, String, Object> destination, Language language, String srcNamespace, String destNamespace) {
        switch (srcNamespace) {
            case "connect-entity-attributes": {
                destination.put((Object)destNamespace, (Object)"entityAttributes", this.entityDynamicAttributesTranslation(language));
                break;
            }
            case "connect-person-roles": {
                destination.put((Object)destNamespace, (Object)"personRoles", this.rolesTranslation(language));
                break;
            }
            case "connect-entity-status": {
                destination.put((Object)destNamespace, (Object)"entityStatus", this.entityStatusTranslation(language));
                break;
            }
            case "profile-attributes-default": {
                destination.row((Object)destNamespace).putAll(this._profileService.getProfileAttributesDefaultTranslations());
                break;
            }
            case "search-filters": {
                destination.put((Object)destNamespace, (Object)"searchFilters", this.dynamicSearchFiltersTranslations());
            }
        }
    }

    @Nonnull
    private Map<String, Object> dynamicSearchFiltersTranslations() {
        HashMap<CallSite, CallSite> result = new HashMap<CallSite, CallSite>();
        String profileAttributeFilterNameKey = "profileAttributeFilterName";
        String profileAttributeOptionNameKey = "profileAttributeOptionName";
        ProfileAttributesConfiguration config = this._profileReadWriteDataService.getAttributesConfiguration();
        for (ProfileSectionConfiguration section : config.getSections()) {
            for (ProfileAttributeConfiguration attribute : section.getAttributes()) {
                if (attribute.getSearchable() != ProfileAttributeSearchType.FACET) continue;
                result.put((CallSite)((Object)("profileAttributeFilterName_" + attribute.getName())), (CallSite)((Object)("$t(profileAttribute." + attribute.getName() + ")")));
                ImmutableList values = ProfileAttributeType.TREE_SELECT.equals((Object)attribute.getType()) ? attribute.getTreeValues().getNames().asList() : attribute.getValues();
                if (CollectionUtil.isEmpty(values)) continue;
                for (String value : values) {
                    result.put((CallSite)((Object)("profileAttributeOptionName_" + value.toLowerCase())), (CallSite)((Object)("$t(profileAttribute." + value + ")")));
                }
            }
        }
        return ImmutableMap.of((Object)"filter", result);
    }

    private static void mergeIntoDestination(Map<String, Object> translation, Map<String, Object> destination) {
        for (Map.Entry<String, Object> entry : translation.entrySet()) {
            Object oldValues = destination.get(entry.getKey());
            Object merged = I18nextServiceImpl.mergeValues(oldValues, entry.getValue());
            if (merged == null) continue;
            destination.put(entry.getKey(), merged);
        }
    }

    @CheckForNull
    private static Object mergeValues(@Nullable Object oldValues, @Nullable Object newValues) {
        if (oldValues == null) {
            return newValues;
        }
        if (newValues instanceof Map) {
            Map newValuesMap = (Map)newValues;
            if (oldValues instanceof Map) {
                Map oldValuesMap = (Map)oldValues;
                for (Map.Entry entry : newValuesMap.entrySet()) {
                    Object oldSubValues = oldValuesMap.get(entry.getKey());
                    Object merged = I18nextServiceImpl.mergeValues(oldSubValues, entry.getValue());
                    if (merged == null) continue;
                    oldValuesMap.put((String)entry.getKey(), merged);
                }
                return oldValues;
            }
        }
        return newValues;
    }

    @Nonnull
    private static String getMainLocale(String language) {
        return language.split("-")[0];
    }
}

