/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.impl;

import com.freiheit.toro.common.business.LanguageService;
import com.freiheit.toro.common.shared.i18n.AlbumConstants;
import com.freiheit.toro.common.shared.i18n.AlbumMessages;
import com.freiheit.toro.common.shared.i18n.BasicConstants;
import com.freiheit.toro.common.shared.i18n.BasicMessages;
import com.freiheit.toro.common.shared.i18n.DateAndTimeConstants;
import com.freiheit.toro.common.shared.i18n.DocumentConstants;
import com.freiheit.toro.common.shared.i18n.DocumentMessages;
import com.freiheit.toro.common.shared.i18n.ExceptionConstants;
import com.freiheit.toro.common.shared.i18n.ExceptionMessages;
import com.freiheit.toro.common.shared.i18n.FooterpagesConstants;
import com.freiheit.toro.common.shared.i18n.LoginConstants;
import com.freiheit.toro.common.shared.i18n.SearchConstants;
import com.freiheit.toro.common.shared.i18n.SearchFilterMessages;
import com.freiheit.toro.common.shared.i18n.SearchMessages;
import com.freiheit.toro.common.shared.i18n.SearchProviderConstants;
import com.freiheit.toro.common.shared.i18n.VideolinkConstants;
import com.freiheit.toro.common.shared.i18n.VideolinkMessages;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.gwt.i18n.dynamic.client.DynamicI18n;
import de.justsoftware.gwt.i18n.dynamic.server.GWTDynamicI18nUtils;
import de.justsoftware.onx.administration.shared.i18n.AdministrationMessages;
import de.justsoftware.onx.chat.shared.i18n.ChatConstants;
import de.justsoftware.onx.comments.shared.i18n.CommentConstants;
import de.justsoftware.onx.comments.shared.i18n.CommentMessages;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerLocalizedMessages;
import de.justsoftware.onx.common.business.configfile.ConfigFileChangeEvent;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.business.impl.ServerDateFormatter;
import de.justsoftware.onx.common.business.impl.ServerLocalizedMessagesImpl;
import de.justsoftware.onx.common.shared.i18n.CalendarConstants;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.i18n.EntityTranslationUtil;
import de.justsoftware.onx.common.shared.model.StringId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicEntityAttributesMessages;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.SelectOptionMessage;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.property.marker.DynamicProperty;
import de.justsoftware.onx.container.server.i18n.DynamicAttributeErrorMessages;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.i18n.EntityStatusMessages;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.i18n.NotificationCenterEntityMessages;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.design.shared.model.ThemeI18nMessages;
import de.justsoftware.onx.export.csv.server.i18n.CsvExportConstants;
import de.justsoftware.onx.license.shared.i18n.LicenseMessages;
import de.justsoftware.onx.like.shared.i18n.LikeMessages;
import de.justsoftware.onx.mail.i18n.CommonMails;
import de.justsoftware.onx.mail.i18n.EmailConstants;
import de.justsoftware.onx.mail.i18n.EmailMessages;
import de.justsoftware.onx.mail.i18n.EntityMails;
import de.justsoftware.onx.migration.shared.i18n.ImportMessages;
import de.justsoftware.onx.multiwiki.shared.i18n.MultiWikiMessages;
import de.justsoftware.onx.notifications.shared.i18n.NotificationCenterMessages;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.i18n.ProfileMessages;
import de.justsoftware.onx.process.business.model.ProcessConfigurationChangedEvent;
import de.justsoftware.onx.push.i18n.PushMessages;
import de.justsoftware.onx.raweditor.shared.i18n.RawEditorConstants;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import de.justsoftware.onx.survey.shared.i18n.SurveyMessages;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorConstants;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorMessages;
import de.justsoftware.onx.workstream.shared.i18n.WorkstreamConstants;
import de.justsoftware.onx.workstream.shared.i18n.WorkstreamFilterMessages;
import de.justsoftware.onx.workstream.shared.i18n.WorkstreamMessages;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterId;
import de.justsoftware.propeye.factory.PropertiesProxyFactory;
import de.justsoftware.propeye.handler.PropertiesHandler;
import de.justsoftware.propeye.property.Properties;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParametersAreNonnullByDefault
public class I18nServiceImpl
implements ServerEventHandler,
I18nService {
    private static final Ordering<Class<?>> CLASS_BY_NAME_ORDERING = Ordering.natural().onResultOf(input -> input != null ? input.getName() : null);
    private final PropertiesHandler _propertiesHandler;
    private final LanguageService _languageService;
    private final EntityConfigService _entityConfigService;
    private final ConfigService _configService;
    private final ConcurrentMap<Class<? extends DynamicProperty>, CustomPropertiesProxyFactory<? extends DynamicProperty>> _propertyFactoryMap = Maps.newConcurrentMap();
    private final ConcurrentMap<String, CustomPropertiesProxyFactory<? extends DynamicProperty>> _propertyFactoryMapByName = Maps.newConcurrentMap();

    @Autowired
    @ParametersAreNonnullByDefault
    public I18nServiceImpl(@Qualifier(value="resourceBundlePropertyHandler") PropertiesHandler propertiesHandler, LanguageService languageService, EntityConfigService entityConfigService, ConfigService configService) {
        this._propertiesHandler = propertiesHandler;
        this._languageService = languageService;
        this._entityConfigService = entityConfigService;
        this._configService = configService;
    }

    @PostConstruct
    protected void initTranslations() {
        this.initPropertyClassData(LoginConstants.class);
        this.initPropertyClassData(BasicConstants.class);
        this.initPropertyClassData(BasicMessages.class);
        this.initPropertyClassData(AlbumConstants.class);
        this.initPropertyClassData(AlbumMessages.class);
        this.initPropertyClassData(SearchConstants.class);
        this.initPropertyClassData(SearchMessages.class);
        this.initPropertyClassData(FooterpagesConstants.class);
        this.initPropertyClassData(ExceptionConstants.class);
        this.initPropertyClassData(ExceptionMessages.class);
        this.initPropertyClassData(DateAndTimeConstants.class);
        this.initPropertyClassData(CommonMails.class);
        this.initPropertyClassData(VideolinkConstants.class);
        this.initPropertyClassData(VideolinkMessages.class);
        this.initPropertyClassData(DocumentConstants.class);
        this.initPropertyClassData(DocumentMessages.class);
        this.initPropertyClassData(WikiEditorMessages.class);
        this.initPropertyClassData(WikiEditorConstants.class);
        this.initPropertyClassData(WorkstreamMessages.class);
        this.initPropertyClassData(WorkstreamConstants.class);
        this.initPropertyClassData(RawEditorConstants.class);
        this.initPropertyClassData(ProfileConstants.class);
        this.initPropertyClassData(ProfileMessages.class);
        this.initPropertyClassData(LikeMessages.class);
        this.initPropertyClassData(MultiWikiMessages.class);
        this.initPropertyClassData(CsvExportConstants.class);
        this.initPropertyClassData(de.justsoftware.onx.common.shared.i18n.BasicConstants.class);
        this.initPropertyClassData(SurveyConstants.class);
        this.initPropertyClassData(SurveyMessages.class);
        this.initPropertyClassData(CalendarConstants.class);
        this.initPropertyClassData(EmailConstants.class);
        this.initPropertyClassData(EmailMessages.class);
        this.initPropertyClassData(ChatConstants.class);
        this.initPropertyClassData(CommentConstants.class);
        this.initPropertyClassData(CommentMessages.class);
        this.initPropertyClassData(EntityVersionConstants.class);
        this.initPropertyClassData(DynamicAttributeErrorMessages.class);
        this.initPropertyClassData(AdministrationMessages.class);
        this.initPropertyClassData(LicenseMessages.class);
        this.initPropertyClassData(ThemeI18nMessages.class);
        this.initPropertyClassData(PushMessages.class);
        this.initPropertyClassData(ImportMessages.class);
        this.initPropertyClassData(NotificationCenterMessages.class);
        this.initEntitySpecificTranslations();
        this.initWorkstreamSpecificTranslations();
        this.initSearchFilterTranslations();
    }

    private void initEntitySpecificTranslations() {
        this.initEntitySpecificMessages(EntityMails.class, PropertiesProxyFactory.DimensionStrategy.APPEND);
        this.initEntitySpecificMessages(EntityConstants.class, PropertiesProxyFactory.DimensionStrategy.APPEND);
        this.initEntitySpecificMessages(EntityMessages.class, PropertiesProxyFactory.DimensionStrategy.APPEND);
        this.initEntitySpecificMessages(NotificationCenterEntityMessages.class, PropertiesProxyFactory.DimensionStrategy.APPEND);
        this.initDynamicEntityAttributes();
        this.initEntityStatusTranslations();
    }

    private void initWorkstreamSpecificTranslations() {
        Iterable filterNames = Iterables.transform(this._configService.getAllWorkstreamFilterIds(), StringId.TO_STRING);
        this.buildPropertyFactoryMap(WorkstreamFilterMessages.class, PropertiesProxyFactory.DimensionStrategy.PREPEND, filterNames, true, I18nService.DimensionType.WORKSTREAM_FILTER_IDS);
    }

    private void initSearchFilterTranslations() {
        Class<SearchFilterMessages> propertyClass = SearchFilterMessages.class;
        Iterable filterNames = Iterables.transform((Iterable)this._configService.getSearchTextBoxFilters().getFilters().keySet(), StringId.TO_STRING);
        this.buildPropertyFactoryMap(propertyClass, PropertiesProxyFactory.DimensionStrategy.PREPEND, filterNames, true, I18nService.DimensionType.SEARCH_TEXT_BOX);
    }

    private <T extends DynamicProperty> void initDynamicEntityAttributes() {
        ImmutableSet<EntityType> entities = this._entityConfigService.getOrderedEntityTypes();
        for (final EntityType type : entities) {
            ImmutableList<DynamicAttributeConfig> attributes = this._entityConfigService.getDynamicAttributesForType(type);
            if (attributes.isEmpty()) continue;
            Iterable attributeDimensions = Iterables.transform(attributes, (Function)new Function<DynamicAttributeConfig, String>(){

                public String apply(DynamicAttributeConfig attr) {
                    return EntityTranslationUtil.getEntityTypeAttributesKeyPart(type, attr.getId());
                }
            });
            this.buildPropertyFactoryMap(DynamicEntityAttributesMessages.class, PropertiesProxyFactory.DimensionStrategy.PREPEND, attributeDimensions, false, I18nService.DimensionType.ENTITY_TYPE_AND_DYNAMIC_ATTRIBUTE);
            for (DynamicAttributeConfig attr : attributes) {
                Input input = attr.getInput();
                if (!(input instanceof SelectionInput)) continue;
                SelectionInput selection = (SelectionInput)input;
                for (String value : selection.getValues()) {
                    this.buildPropertyFactoryMap(SelectOptionMessage.class, PropertiesProxyFactory.DimensionStrategy.PREPEND, (Iterable<String>)ImmutableList.of((Object)EntityTranslationUtil.getDynamicOptionTranslationKey(type, attr.getId(), value)), false, I18nService.DimensionType.ENTITY_TYPE_AND_DYNAMIC_ATTRIBUTE_SELECT);
                }
            }
        }
    }

    private void initEntityStatusTranslations() {
        ImmutableSet<EntityType> entities = this._entityConfigService.getOrderedEntityTypes();
        for (EntityType type : entities) {
            ImmutableSet<EntityStatus> entityStatus = this._entityConfigService.getAvailableEntityStatus(type);
            if (entityStatus.isEmpty()) continue;
            Iterable statusDimensions = Iterables.transform(entityStatus, (Function)new Function<EntityStatus, String>(){

                public String apply(EntityStatus status) {
                    return status.getI18nKey();
                }
            });
            this.buildPropertyFactoryMap(EntityStatusMessages.class, PropertiesProxyFactory.DimensionStrategy.PREPEND, statusDimensions, false, I18nService.DimensionType.ENTITY_TYPE_AND_STATUS);
        }
    }

    @Override
    public Map<String, SelectOptionMessage> getSelectOptionMessagesForAttribute(EntityType type, DynamicAttributeId attributeId, Iterable<String> values, String locale) {
        ImmutableMap.Builder messageMap = ImmutableMap.builder();
        for (String value : ImmutableSet.copyOf(values)) {
            SelectOptionMessage proxy = I18nServiceImpl.createPropertiesProxy(this.determineProxyFactory(SelectOptionMessage.class), locale, EntityTranslationUtil.getDynamicOptionTranslationKey(type, attributeId, value));
            messageMap.put((Object)value, (Object)proxy);
        }
        return messageMap.build();
    }

    @Override
    public DynamicEntityAttributesMessages getEntityAttributeMessages(EntityType type, DynamicAttributeId attributeId, String locale) {
        String messageKey = EntityTranslationUtil.getEntityTypeAttributesKeyPart(type, attributeId);
        return I18nServiceImpl.createPropertiesProxy(this.determineProxyFactory(DynamicEntityAttributesMessages.class), locale, messageKey);
    }

    private <T extends DynamicProperty> void initEntitySpecificMessages(Class<T> propertyClass, PropertiesProxyFactory.DimensionStrategy strategy) {
        ImmutableSet<EntityType> entities = this._entityConfigService.getOrderedEntityTypes();
        Iterable entityDimensions = Iterables.transform(entities, (Function)new Function<EntityType, String>(){

            public String apply(EntityType entityType) {
                return EntityTranslationUtil.getEntityTypeKeyPart(entityType);
            }
        });
        this.buildPropertyFactoryMap(propertyClass, strategy, entityDimensions, true, I18nService.DimensionType.ENTITY_TYPE);
    }

    @Override
    public void initSearchProviderSpecificMessages(ImmutableSet<SearchProviderId> providerIds) {
        Iterable dimensions = Iterables.transform(providerIds, (Function)new Function<SearchProviderId, String>(){

            public String apply(SearchProviderId input) {
                return input.getId();
            }
        });
        this.buildPropertyFactoryMap(SearchProviderConstants.class, PropertiesProxyFactory.DimensionStrategy.PREPEND, dimensions, false, I18nService.DimensionType.SEARCH_PROVIDERS);
    }

    private <T extends DynamicProperty> void buildPropertyFactoryMap(Class<T> propertyClass, PropertiesProxyFactory.DimensionStrategy strategy, Iterable<String> dimensions, boolean buildDefaultProperties, I18nService.DimensionType dimensionType) {
        CustomPropertiesProxyFactory propFactory = (CustomPropertiesProxyFactory)((Object)this._propertyFactoryMap.get(propertyClass));
        if (propFactory != null) {
            for (String dimension : dimensions) {
                propFactory.addDimension(dimension);
            }
        } else {
            CustomPropertiesProxyFactory<T> newPropFactory = new CustomPropertiesProxyFactory<T>(propertyClass, dimensions, strategy, buildDefaultProperties, dimensionType);
            this.putIntoMaps(propertyClass, newPropFactory);
        }
    }

    @Nonnull
    private <T extends DynamicProperty> PropertiesProxyFactory<T> putIntoMaps(Class<T> propertyClass, CustomPropertiesProxyFactory<T> newPropFactory) {
        CustomPropertiesProxyFactory<T> existing1 = this._propertyFactoryMap.putIfAbsent(propertyClass, newPropFactory);
        CustomPropertiesProxyFactory result1 = (CustomPropertiesProxyFactory)((Object)MoreObjects.firstNonNull(existing1, newPropFactory));
        PropertiesProxyFactory existing2 = this._propertyFactoryMapByName.putIfAbsent(GWTDynamicI18nUtils.getDictonaryNameFromClass(propertyClass), result1);
        return (PropertiesProxyFactory)MoreObjects.firstNonNull((Object)existing2, (Object)((Object)result1));
    }

    @Nonnull
    private <T extends DynamicProperty> PropertiesProxyFactory<T> determineProxyFactory(Class<T> propertyClass) {
        PropertiesProxyFactory result = (PropertiesProxyFactory)this._propertyFactoryMap.get(propertyClass);
        if (result != null) {
            return result;
        }
        return this.putIntoMaps(propertyClass, new CustomPropertiesProxyFactory<T>(propertyClass));
    }

    @Override
    public <T extends DynamicProperty> T createProxy(Class<T> interfaceType, String locale) {
        return I18nServiceImpl.createPropertiesProxy(this.determineProxyFactory(interfaceType), locale);
    }

    @Override
    public <T extends DynamicProperty> T createProxy(String name, EntityType entityType, String locale) {
        CustomPropertiesProxyFactory factory = (CustomPropertiesProxyFactory)((Object)this._propertyFactoryMapByName.get(name));
        return I18nServiceImpl.createPropertiesProxy(factory, locale, entityType);
    }

    @Override
    public I18nService.DimensionType getDimensionType(String name) {
        CustomPropertiesProxyFactory factory = (CustomPropertiesProxyFactory)((Object)this._propertyFactoryMapByName.get(name));
        return factory != null ? factory.getDimensionType() : null;
    }

    @Override
    public <T extends DynamicProperty> T createProxy(Class<T> interfaceType, EntityType entityType, String locale) {
        return I18nServiceImpl.createPropertiesProxy(this.determineProxyFactory(interfaceType), locale, entityType);
    }

    @Override
    public <T extends DynamicProperty> T createProxy(Class<T> interfaceType, String dimension, String locale) {
        return I18nServiceImpl.createPropertiesProxy(this.determineProxyFactory(interfaceType), locale, dimension);
    }

    @Nonnull
    private static <T extends DynamicProperty> T createPropertiesProxy(PropertiesProxyFactory<T> factory, String locale, @Nullable EntityType dimension) {
        return I18nServiceImpl.createPropertiesProxy(factory, locale, dimension != null ? EntityTranslationUtil.getEntityTypeKeyPart(dimension) : null);
    }

    @Nonnull
    private static <T extends DynamicProperty> T createPropertiesProxy(PropertiesProxyFactory<T> factory, String locale) {
        return I18nServiceImpl.createPropertiesProxy(factory, locale, (String)null);
    }

    @Nonnull
    private static <T extends DynamicProperty> T createPropertiesProxy(PropertiesProxyFactory<T> factory, String locale, @Nullable String dimension) {
        try {
            return (T)((DynamicProperty)factory.createPropertiesProxy(locale, dimension));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public <T extends DynamicProperty> T createProxy(Class<T> interfaceType, WorkstreamFilterId dimension, String locale) {
        return I18nServiceImpl.createPropertiesProxy(this.determineProxyFactory(interfaceType), locale, dimension.getId());
    }

    @Override
    public void initPropertyClassData(Class<? extends DynamicProperty> interfaceType) {
        this.determineProxyFactory(interfaceType);
    }

    @Override
    public EntityConstants getEntityConstantsByEntityType(EntityType type, String locale) {
        return this.createProxy(EntityConstants.class, type, locale);
    }

    @Override
    public ImmutableMap<EntityType, EntityConstants> getEntityConstants(String locale) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (EntityType t : this._entityConfigService.getOrderedEntityTypes()) {
            result.put((Object)t, (Object)this.getEntityConstantsByEntityType(t, locale));
        }
        return result.build();
    }

    @Override
    public EntityMessages getEntityMessagesByEntityType(EntityType type, String locale) {
        return this.createProxy(EntityMessages.class, type, locale);
    }

    @Override
    public NotificationCenterEntityMessages getNotificationCenterEntityMessagesByEntityType(EntityType type, String locale) {
        return this.createProxy(NotificationCenterEntityMessages.class, type, locale);
    }

    @Override
    public WorkstreamFilterMessages getWorkstreamFilterMessagesByFilter(WorkstreamFilterId filter, String locale) {
        return this.createProxy(WorkstreamFilterMessages.class, filter, locale);
    }

    @Override
    public ImmutableMap<EntityType, EntityMessages> getEntityMessages(String locale) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (EntityType t : this._entityConfigService.getOrderedEntityTypes()) {
            result.put((Object)t, (Object)this.getEntityMessagesByEntityType(t, locale));
        }
        return result.build();
    }

    @Override
    public EntityMails getEntityMailsByEntityType(EntityType type, String locale) {
        return this.createProxy(EntityMails.class, type, locale);
    }

    @Override
    public SearchProviderConstants getSearchProviderMessages(SearchProviderId providerId, String locale) {
        return I18nServiceImpl.createPropertiesProxy(this.determineProxyFactory(SearchProviderConstants.class), locale, providerId.getId());
    }

    @Override
    public ImmutableSet<String> getAvailableLanguages() {
        return this._languageService.getAvailableLanguageCode();
    }

    @Override
    public String getJavaScriptDictionaryString(String locale, boolean displayPropertyKeys) {
        StringBuffer result = new StringBuffer();
        ImmutableList propertyClasses = CLASS_BY_NAME_ORDERING.immutableSortedCopy(this._propertyFactoryMap.keySet());
        for (Class c : propertyClasses) {
            if (c.getAnnotation(DynamicI18n.DynamicI18nDictionaryName.class) == null || c.getAnnotation(I18nService.ServerOnly.class) != null) continue;
            TreeMap properties = new TreeMap(this.determineProxyFactory(c).createMethodNameKeyPropertyStringRepresentationMap(locale, displayPropertyKeys));
            result.append("\n").append(GWTDynamicI18nUtils.createHostPageDictionary((Class)c, properties));
        }
        return result.toString();
    }

    @Override
    public ServerLocalizedMessages getLocalizedMessages(String locale) {
        return new ServerLocalizedMessagesImpl(this, locale);
    }

    @Subscribe
    public void onConfigChange(ConfigFileChangeEvent event) {
        this.initEntitySpecificTranslations();
        this.initWorkstreamSpecificTranslations();
        this.initSearchFilterTranslations();
    }

    @Subscribe
    public void onProcessConfigurationChanged(ProcessConfigurationChangedEvent event) {
        this.initEntitySpecificTranslations();
    }

    @Override
    public DateFormatter dateFormatter(String locale) {
        return new ServerDateFormatter(this.getLocalizedMessages(locale), null);
    }

    @ParametersAreNonnullByDefault
    private class CustomPropertiesProxyFactory<T extends Properties>
    extends PropertiesProxyFactory<T> {
        private final I18nService.DimensionType _dimensionType;

        CustomPropertiesProxyFactory(Class<T> type) {
            super(type, I18nServiceImpl.this._propertiesHandler);
            this._dimensionType = null;
        }

        CustomPropertiesProxyFactory(Class<T> type, Iterable<String> optionalDimensions, PropertiesProxyFactory.DimensionStrategy strategy, boolean initPropertiesWithoutDimension, I18nService.DimensionType dimensionType) {
            super(type, I18nServiceImpl.this._propertiesHandler, optionalDimensions, strategy, initPropertiesWithoutDimension);
            this._dimensionType = dimensionType;
        }

        @CheckForNull
        final I18nService.DimensionType getDimensionType() {
            return this._dimensionType;
        }

        public final T createPropertiesProxy(@Nullable String domain, @Nullable String dimension) throws Exception {
            return (T)super.createPropertiesProxy(domain, this._dimensionType != null ? dimension : null);
        }
    }
}

