/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.business.HostPropertiesLoader;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.configfile.ProfileConfigService;
import de.justsoftware.onx.common.shared.model.ClientEntityConfigBean;
import de.justsoftware.onx.common.shared.model.HostPropertiesBean;
import de.justsoftware.onx.common.shared.model.ParentEntityConfig;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.business.EntityTypeAppMappingService;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.shared.model.PersonRolesClientTranslation;
import de.justsoftware.onx.profile.business.ProfileAttributeTranslationService;
import de.justsoftware.onx.profile.business.ProfileReadDataService;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributeSearchType;
import de.justsoftware.onx.searchnew.business.FilterConfiguration;
import de.justsoftware.onx.searchnew.shared.model.TranslatedProfileAttributeFacet;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class HostPropertiesLoaderImpl
implements HostPropertiesLoader {
    private static final long MAX_FILE_SIZE_IN_BYTES = 0xFA00000L;
    private final FilterConfiguration _filterConfiguration;
    private final Settings _settings;
    private final PersonService _personService;
    private final PersonRoleService _personRoleService;
    private final ServerUrlUtil _serverUrlUtil;
    private final EntityConfigService _entityConfigService;
    private final ConfigService _configService;
    private final ProfileConfigService _profileConfigService;
    private final ProfileReadDataService _profileReadDataService;
    private final ProfileAttributeTranslationService _profileAttributeTranslationService;
    private final EntityTypeAppMappingService _entityTypeAppMappingService;

    @Autowired
    public HostPropertiesLoaderImpl(FilterConfiguration filterConfiguration, Settings settings, PersonService personService, PersonRoleService personRoleService, ServerUrlUtil serverUrlUtil, EntityConfigService entityConfigService, ConfigService configService, ProfileConfigService profileConfigService, ProfileReadDataService profileReadDataService, ProfileAttributeTranslationService profileAttributeTranslationService, EntityTypeAppMappingService entityTypeAppMappingService) {
        this._filterConfiguration = filterConfiguration;
        this._settings = settings;
        this._personService = personService;
        this._personRoleService = personRoleService;
        this._serverUrlUtil = serverUrlUtil;
        this._entityConfigService = entityConfigService;
        this._configService = configService;
        this._profileConfigService = profileConfigService;
        this._profileReadDataService = profileReadDataService;
        this._profileAttributeTranslationService = profileAttributeTranslationService;
        this._entityTypeAppMappingService = entityTypeAppMappingService;
    }

    @Override
    public HostPropertiesBean getHostPropertiesByLocale(String locale) {
        HostPropertiesBean hostPropertiesBean = new HostPropertiesBean();
        hostPropertiesBean.setDomain(this._serverUrlUtil.getSystemDomain());
        hostPropertiesBean.setProtocol(this._serverUrlUtil.getSystemProtocol());
        hostPropertiesBean.setMaxImageSize(0xFA00000L);
        hostPropertiesBean.setMaxImageDimensions(4000);
        hostPropertiesBean.setSystemMaxDateYear(this._settings.getSystemMaxDateYear());
        hostPropertiesBean.setSystemMinDateYear(this._settings.getSystemMinDateYear());
        hostPropertiesBean.setOrderedFilterTypes(this._filterConfiguration.getOrderedFilterTypes());
        hostPropertiesBean.setCollapseToRestrictingFilters(this._settings.isCollapseToRestrictingFilters());
        hostPropertiesBean.setAlwaysShowSearchContextFilter(this._settings.isAlwaysShowSearchContextFilter());
        hostPropertiesBean.setAdditionalTermsAcceptanceRequired(this._settings.isAdditionalTermsAcceptanceRequired());
        hostPropertiesBean.setTermsAcceptanceRequired(this._settings.isTermsAcceptanceRequired());
        hostPropertiesBean.setActivationViaOptInEnabled(this._settings.isActivationViaOptInEnabled());
        hostPropertiesBean.setGoogleAnalyticsAccount(this._settings.getGoogleAnalyticsAccount());
        hostPropertiesBean.setTestingSystem(this._settings.isClientLoggingEnable());
        hostPropertiesBean.setPersonRolesTranslation(this.convertPersonRolesTranslation(locale));
        hostPropertiesBean.setSocialAppStartToken(this._configService.getSocialAppStartToken());
        hostPropertiesBean.setMaxDirectMessageLength(this._settings.getMaxDirectMessageLength());
        hostPropertiesBean.setSearchContextShown(this._settings.getSearchContextShown());
        hostPropertiesBean.setShowFooterPageAboutInSameWindow(this._settings.isShowFooterPageAboutInSameWindow());
        hostPropertiesBean.setShowFooterPageDataProtectionInSameWindow(this._settings.isShowFooterPageDataProtectionInSameWindow());
        hostPropertiesBean.setShowFooterPageHelpInSameWindow(this._settings.isShowFooterPageHelpInSameWindow());
        hostPropertiesBean.setShowFooterPageImprintInSameWindow(this._settings.isShowFooterPageImprintInSameWindow());
        hostPropertiesBean.setShowFooterPageArticleOfAssociationInSameWindow(this._settings.isShowFooterPageArticleOfAssociationInSameWindow());
        hostPropertiesBean.setShowFooterPagePressInSameWindow(this._settings.isShowFooterPagePressInSameWindow());
        hostPropertiesBean.setShowFooterPageTermsInSameWindow(this._settings.isShowFooterPageTermsInSameWindow());
        hostPropertiesBean.setPasswordResetEnabled(this._settings.isPasswordResetEnabled());
        hostPropertiesBean.setModificationRestrictedPersonFields(this._settings.getModificationRestrictedPersonFields());
        hostPropertiesBean.setHiddenPersonFields(this._settings.getHiddenPersonFields());
        hostPropertiesBean.setOrdinaryUsersMayInviteMembers(this._settings.isOrdinaryUsersMayInviteMembers());
        hostPropertiesBean.setVisibleRoleNames(this._personRoleService.getVisibleRoleNames());
        hostPropertiesBean.setFavIconUrl(this._settings.getFavIconUrl());
        hostPropertiesBean.setShowBirthdaysOnStartPage(this._settings.getShowBirthdaysOnStartPage().isShown());
        hostPropertiesBean.setActiveOrderedEntityTypes(this.getActiveOrderedEntityTypes());
        hostPropertiesBean.setClientEntityConfig(this.getClientEntityConfig());
        hostPropertiesBean.setWorkstreamReadConfig(this._settings.getWorkstreamReadConfig());
        hostPropertiesBean.setWorkstreamMessageDisplayedLength(this._configService.getWorkstreamMessageDisplayedLength());
        hostPropertiesBean.setCommentsDisplayedLength(this._configService.getCommentsDisplayedLength());
        hostPropertiesBean.setNotificationMessageDisplayedLength(this._configService.getNotificationMessageDisplayedLength());
        hostPropertiesBean.setCopyAddressIconActivated(this._configService.isCopyAddressIconActivated());
        hostPropertiesBean.setUseExternalSearchProvider(this._configService.useExternalSearchProvider());
        hostPropertiesBean.setAllWorkstreamFilters(this._configService.getAllWorkstreamFilterIds());
        hostPropertiesBean.setWorkstreamMessageImagePresentationType(this._profileConfigService.getWorkstreamMessageImagePresentationType());
        hostPropertiesBean.setOrdinaryUsersMayRecommendToMembers(this._settings.isOrdinaryUsersMayRecommendToMembers());
        hostPropertiesBean.setSearchTextBoxFilters(this._configService.getSearchTextBoxFilters());
        hostPropertiesBean.setTagsForDocumentsEnabled(this._configService.isTagsForDocumentsEnabled());
        hostPropertiesBean.setPrintPdfVisible(this._configService.isJucoPrintButtonVisible());
        hostPropertiesBean.setHeaderCalendarEntityType(this._configService.getHeaderCalendarEntityType());
        hostPropertiesBean.setHeaderCalendarIconEnabled(this._configService.isHeaderCalendarIconEnabled());
        hostPropertiesBean.setShowIcons(this._settings.showIcons());
        hostPropertiesBean.setDefaultEntityId(this._settings.getDefaultEntityId());
        hostPropertiesBean.setShowProductHints(this._settings.getShowProductHints());
        hostPropertiesBean.setEditorToolbar(this._configService.getEditorToolbar());
        hostPropertiesBean.setShowPinnedWorkstreamOnStartpage(this._configService.isShowPinnedWorkstreamOnStartpage());
        hostPropertiesBean.setLearnToRankEnabled(this._settings.getLearnToRankEnabled());
        this.addProfileAttributeTranslations(hostPropertiesBean, locale);
        return hostPropertiesBean;
    }

    @Nonnull
    private PersonRolesClientTranslation convertPersonRolesTranslation(String locale) {
        return this._personService.getRolesTranslation(locale);
    }

    @Nonnull
    private ImmutableSet<EntityType> getActiveOrderedEntityTypes() {
        return FluentIterable.from(this._entityConfigService.getOrderedEntityTypes()).filter(this._entityConfigService.entityTypeActivated()).toSet();
    }

    @Nonnull
    private ImmutableMap<EntityType, ClientEntityConfigBean> getClientEntityConfig() {
        ImmutableMap.Builder clientEntityConfigBeans = ImmutableMap.builder();
        for (EntityType type : this._entityConfigService.getOrderedEntityTypes()) {
            clientEntityConfigBeans.put((Object)type, (Object)this.createClientEntityConfig(type));
        }
        return clientEntityConfigBeans.build();
    }

    @Nonnull
    private ClientEntityConfigBean createClientEntityConfig(EntityType entityType) {
        ClientEntityConfigBean result = new ClientEntityConfigBean();
        result.setAllowedEntityChildTypes(this._entityConfigService.getAllowedChildrenType(entityType));
        result.setAvailableRuleAuthNames(this._entityConfigService.getAllAvailableRuleAuthNames(entityType));
        for (EntityType parentType : this._entityConfigService.getOrderedEntityTypes()) {
            result.addParentEntityConfig(this.createParentEntityConfig(parentType, entityType));
        }
        result.setDurationTimeOption(this._entityConfigService.getDurationTimeOption(entityType));
        result.setClosingDateActivated(this._entityConfigService.closingDateActivated(entityType));
        result.setFreetextLocationActivated(this._entityConfigService.freetextLocationActivated(entityType));
        result.setParentEntityRequired(this._entityConfigService.linkedEntityRequired(entityType));
        result.setNotifyMemberOnLocationChangeActivated(this._entityConfigService.notifyMemberOnLocationChangeActivated(entityType));
        result.setNotifyMemberOnDurationTimeChangeActivated(this._entityConfigService.notifyMemberOnDurationTimeChangeActivated(entityType));
        result.setUseTypeAhedForReviewerSelection(this._entityConfigService.releaseUseTypeAheadForReviewerSelection(entityType));
        result.setLogoActivated(this._entityConfigService.logoActivated(entityType));
        result.setIconActivated(this._entityConfigService.iconActivated(entityType));
        result.setEntityTypeActivated(this._entityConfigService.entityTypeActivated(entityType));
        result.setDisplayJoinChildPopupOnJoinEntity(this._entityConfigService.displayJoinChildPopupOnJoinEntity(entityType));
        result.setShowOptionAggregateWorkstream(this._entityConfigService.showOptionAggregateWorkstream(entityType));
        result.setDefaultAggregateWorkstream(this._entityConfigService.defaultAggregateWorkstream(entityType));
        result.setShowOptionStreamWorkstreamToParents(this._entityConfigService.showOptionStreamWorkstreamToParents(entityType));
        result.setDefaultStreamWorkstreamToParents(this._entityConfigService.defaultStreamWorkstreamToParents(entityType));
        result.setShowNumberOfSubscribers(this._entityConfigService.showNumberOfSubscribers(entityType));
        result.setShowDescriptionInSearchBadge(this._entityConfigService.showDescriptionInSearchBadge(entityType));
        result.setTeaserLeft(this._entityConfigService.teaserLeft(entityType));
        result.setTeaserCenter(this._entityConfigService.teaserCenter(entityType));
        result.setTeaserRight(this._entityConfigService.teaserRight(entityType));
        result.setIcon(this._entityConfigService.icon(entityType));
        result.setTagsEnabled(this._entityConfigService.tagsEnabled(entityType));
        result.setEnableBrowserSearch(this._entityConfigService.enableBrowserSearch(entityType));
        result.setAddContentButtonEnabled(this._entityConfigService.isAddContentButtonEnabled(entityType));
        result.setDynamicAttributesConfig(this._entityConfigService.getDynamicAttributesForType(entityType));
        result.setSuggestParentsForTypes(this._entityConfigService.getSuggestParentsForTypes(entityType));
        result.setAuthorChangeableOnRelease(this._entityConfigService.isAuthorChangeableOnRelease(entityType));
        result.setReviewersMandatoryForRelease(this._entityConfigService.isReviewMandatoryForRelease(entityType));
        result.setReleaseProcessMandatory(this._entityConfigService.releaseProcessMandatory(entityType));
        result.setReleaseActivationDateVisibility(this._entityConfigService.getReleaseActivationDateVisibility(entityType));
        result.setReleaseExpirationDateVisibility(this._entityConfigService.getReleaseExpirationDateVisibility(entityType));
        result.setReleaseVersionTypeVisibility(this._entityConfigService.getReleaseVersionTypeVisibility(entityType));
        result.setReleaseChangeMessageVisibility(this._entityConfigService.getReleaseChangeMessageVisibility(entityType));
        result.setReleaseCommentForReviewerVisibility(this._entityConfigService.getReleaseCommentForReviewerVisibility(entityType));
        result.setVisibleParentAssignmentTypes(this._entityConfigService.getVisibleParentAssignmentTypes(entityType));
        result.setCheckEntityDuplicateName(this._entityConfigService.isCheckEntityDuplicateName(entityType));
        result.setEntityNamePreset(this._entityConfigService.isEntityNamePreset(entityType));
        result.setVersionReviewerRange(this._entityConfigService.getVersionReleaseReviewerConfig(entityType).getReviewerRange());
        result.setShowArchiveSearchFilter(this._entityConfigService.showArchiveSearchFilter(entityType));
        result.setShowEntityStatusSearchFilter(this._entityConfigService.showEntityStatusSearchFilter(entityType));
        result.setWorkstreamMessageImagePresentationType(this._entityConfigService.getWorkstreamMessageImagePresentationType(entityType));
        result.setShowSaveButton(this._entityConfigService.showSaveButton(entityType));
        result.setEntityMemberWorkflow(this._entityConfigService.getEntityMemberWorkflow(entityType));
        result.setEntityStatusByArchiveFlag((ImmutableSetMultimap<Boolean, EntityStatusId>)ImmutableSetMultimap.copyOf((Multimap)Multimaps.transformValues((ListMultimap)FluentIterable.from(this._entityConfigService.getAvailableEntityStatus(entityType)).index(Functions.forPredicate(EntityStatus.IS_ARCHIVED)), Identifiables.toId())));
        result.setHierarchyFilterTypes(this._entityConfigService.getHierarchyFilterTypes(entityType));
        result.setEntityTabOrder(this._entityConfigService.getEntityTabOrderForEntityType(entityType));
        result.setNavigatorSortType(this._entityConfigService.getNavigatorSortType(entityType));
        result.setNavigatorSearchable(this._entityConfigService.isNavigatorSearchable(entityType));
        result.setRedirectToSurveyOnNewMemberEnabled(this._entityConfigService.isRedirectToSurveyOnNewMemberEnabled(entityType));
        if (!this._settings.isImportPersonsEnabled()) {
            boolean tenantSubscriptionVisible = this._entityTypeAppMappingService.getEntityTypesForApp(CoreApp.ARCHIVED_NEWS).contains((Object)entityType);
            result.setTenantSubscriptionVisible(tenantSubscriptionVisible);
        }
        return result;
    }

    @Nonnull
    private ParentEntityConfig createParentEntityConfig(EntityType parentType, EntityType childType) {
        return new ParentEntityConfig(parentType, this._entityConfigService.minParentCount(parentType, childType), this._entityConfigService.maxParentCount(parentType, childType), this._entityConfigService.inheritsAdminEnabled(parentType, childType), this._entityConfigService.inheritsAdminDefaultValue(parentType, childType), this._entityConfigService.inheritsMemberEnabled(parentType, childType), this._entityConfigService.inheritsMemberDefaultValue(parentType, childType));
    }

    private void addProfileAttributeTranslations(HostPropertiesBean hostPropertiesBean, String locale) {
        ImmutableMap<String, String> i18nMap = this._profileAttributeTranslationService.getProfileAttributeTranslations(locale);
        ImmutableCollection<ProfileAttributeConfiguration> attrCfg = this._profileReadDataService.getAttributesConfiguration().getAllAttributeConfigurations();
        hostPropertiesBean.setProfileAttributeFacets(this.createProfileAttributeFacets(attrCfg, i18nMap));
        hostPropertiesBean.setProfileBadgeFieldTranslation(this.createProfileBadgeFieldTranslation(attrCfg, i18nMap));
    }

    @Nonnull
    private ImmutableList<TranslatedProfileAttributeFacet> createProfileAttributeFacets(ImmutableCollection<ProfileAttributeConfiguration> attrCfg, ImmutableMap<String, String> i18nMap) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ProfileAttributeConfiguration pac : attrCfg) {
            if (!ProfileAttributeSearchType.isFacetable(pac)) continue;
            String name = pac.getName();
            String i18nName = (String)MoreObjects.firstNonNull((Object)((String)i18nMap.get((Object)name)), (Object)name);
            ImmutableSet<String> i18nValueKeys = this.getI18nValueKeys(pac);
            boolean searchInSelectionSupported = CollectionUtil.isEmpty(i18nValueKeys);
            ImmutableMap<String, String> i18nValues = this.translateI18nKeys(i18nValueKeys, i18nMap, (Function<String, String>)((Function)String::toLowerCase), (Function<String, String>)((Function)fallback -> null));
            builder.add((Object)new TranslatedProfileAttributeFacet(name, i18nName, i18nValues, searchInSelectionSupported));
        }
        return builder.build();
    }

    @Nonnull
    private ImmutableMap<String, String> createProfileBadgeFieldTranslation(ImmutableCollection<ProfileAttributeConfiguration> attrCfg, ImmutableMap<String, String> i18nMap) {
        ImmutableSet.Builder i18nKeys = ImmutableSet.builder();
        for (ProfileAttributeConfiguration pac : attrCfg) {
            ProfileAttributeSearchType searchType = pac.getSearchable();
            if (Boolean.TRUE.equals(pac.isVisibleOnBadge()) || searchType == ProfileAttributeSearchType.SEARCH || searchType == ProfileAttributeSearchType.FACET) {
                i18nKeys.add((Object)pac.getName());
            }
            if (!Boolean.TRUE.equals(pac.isVisibleOnBadge())) continue;
            this.addI18nValueKeys((ImmutableSet.Builder<String>)i18nKeys, pac);
        }
        return this.translateI18nKeys((ImmutableSet<String>)i18nKeys.build(), i18nMap, (Function<String, String>)Functions.identity(), (Function<String, String>)Functions.identity());
    }

    @Nonnull
    private ImmutableSet<String> getI18nValueKeys(ProfileAttributeConfiguration pac) {
        ImmutableSet.Builder i18nValueKeys = ImmutableSet.builder();
        this.addI18nValueKeys((ImmutableSet.Builder<String>)i18nValueKeys, pac);
        return i18nValueKeys.build();
    }

    @Nonnull
    private ImmutableMap<String, String> translateI18nKeys(ImmutableSet<String> i18nKeys, ImmutableMap<String, String> i18nMap, Function<String, String> keyTransformer, Function<String, String> valueNotFoundHandler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String i18nKey : i18nKeys) {
            String value;
            String i18nValue = (String)i18nMap.get((Object)i18nKey);
            String key = (String)keyTransformer.apply((Object)i18nKey);
            String string = value = !StringUtil.isBlank(i18nValue) ? i18nValue : (String)valueNotFoundHandler.apply((Object)i18nKey);
            if (key == null || value == null) continue;
            builder.put((Object)key, (Object)value);
        }
        return builder.build();
    }

    private void addI18nValueKeys(ImmutableSet.Builder<String> i18nKeys, ProfileAttributeConfiguration pac) {
        switch (pac.getType()) {
            case CHECKRADIO: 
            case SELECT: {
                ImmutableList<String> values = pac.getValues();
                if (values == null) break;
                i18nKeys.addAll(values);
                break;
            }
            case TREE_SELECT: {
                i18nKeys.addAll(pac.getTreeValues().getNames());
                break;
            }
        }
    }
}

