/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.pathmatcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import de.justsoftware.onx.common.business.configfile.pathmatcher.PathElement;
import de.justsoftware.onx.common.business.configfile.pathmatcher.PathMatchElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PathMatcher<T, C> {
    public static final String ANY = "*";
    public static final String ANYANY = "**";
    public static final String EPSILON = "";
    private static final Ordering<NFAState> ORDER = Ordering.natural().onResultOf(s -> Integer.valueOf(s.getPathNum()));
    private final NFAState _start = new NFAState(context -> true);
    private int _idCount = 0;
    private int _pathCount = 0;

    @Nonnull
    private NFAState addWordState(NFAState last, PathElement<C> w) {
        NFAState next = new NFAState(w::test);
        last.addNextState(w.getWord(), next);
        return next;
    }

    @Nonnull
    private NFAState addAnyAnyState(NFAState last) {
        NFAState next = new NFAState(context -> true);
        last.addNextState(EPSILON, next);
        next.addNextState(ANY, next);
        return next;
    }

    public void add(List<? extends PathElement<C>> path, T obj) {
        NFAState currentState = this._start;
        block10: for (PathElement<C> w : this.prepareList(path)) {
            String word;
            switch (word = w.getWord()) {
                case "": {
                    continue block10;
                }
                case "*": {
                    currentState = this.addWordState(currentState, w);
                    continue block10;
                }
                case "**": {
                    currentState = this.addAnyAnyState(currentState);
                    continue block10;
                }
            }
            currentState = this.addWordState(currentState, w);
        }
        currentState.setObject(obj);
    }

    @Nonnull
    protected <X> List<X> prepareList(List<X> path) {
        return path;
    }

    @Nonnull
    public Optional<T> get(List<? extends PathMatchElement<C>> path) {
        Iterable<NFAState> unordered = this.allUnorderedMatches(path);
        return Iterables.isEmpty(unordered) ? Optional.empty() : Optional.of(((NFAState)ORDER.max(unordered)).getObject());
    }

    @Nonnull
    public List<T> getAllMatches(List<? extends PathMatchElement<C>> path) {
        return Lists.transform((List)ORDER.immutableSortedCopy(this.allUnorderedMatches(path)), NFAState::getObject);
    }

    @Nonnull
    private Iterable<NFAState> allUnorderedMatches(List<? extends PathMatchElement<C>> path) {
        NFAStateSet currentState = new NFAStateSet();
        for (PathMatchElement<C> w : this.prepareList(path)) {
            if (w.getWord().equals(EPSILON)) continue;
            currentState = currentState.nextStateSet(w);
        }
        return Iterables.filter(currentState.getStates(), NFAState::isEndState);
    }

    public static class ReversedPathMatcher<T, C>
    extends PathMatcher<T, C> {
        @Override
        protected <X> List<X> prepareList(List<X> path) {
            return Lists.reverse(path);
        }
    }

    @ParametersAreNonnullByDefault
    private final class NFAState {
        private final int _id;
        private final Predicate<C> _condition;
        private T _object = null;
        private int _pathNum = 0;
        private final Multimap<String, NFAState> _nextState = HashMultimap.create();

        public NFAState(Predicate<C> condition) {
            this._id = PathMatcher.this._idCount++;
            this._condition = condition;
        }

        public void addNextState(String w, NFAState s) {
            this._nextState.put((Object)w, (Object)s);
        }

        public void collectEpsilon(HashSet<NFAState> nextStates, @Nullable C context) {
            if (this._condition.test(context) && nextStates.add(this)) {
                for (NFAState s : this._nextState.get((Object)PathMatcher.EPSILON)) {
                    s.collectEpsilon(nextStates, context);
                }
            }
        }

        public void collectNextState(PathMatchElement<C> w, HashSet<NFAState> nextStates) {
            for (NFAState s : Iterables.concat((Iterable)this._nextState.get((Object)w.getWord()), (Iterable)this._nextState.get((Object)PathMatcher.ANY))) {
                s.collectEpsilon(nextStates, w.getContext());
            }
        }

        @Nonnull
        public T getObject() {
            return Preconditions.checkNotNull(this._object);
        }

        public void setObject(T object) {
            if (this._object != null || this._pathNum != 0) {
                throw new IllegalStateException();
            }
            this._object = object;
            this._pathNum = ++PathMatcher.this._pathCount;
        }

        public int getPathNum() {
            return this._pathNum;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append(this._id + "[" + this._condition + "](");
            String comma1 = PathMatcher.EPSILON;
            for (Map.Entry e : this._nextState.asMap().entrySet()) {
                sb.append(comma1).append((String)e.getKey() + "->{");
                comma1 = ", ";
                String comma2 = PathMatcher.EPSILON;
                for (NFAState s : (Collection)e.getValue()) {
                    sb.append(comma2).append(s._id + "[" + s._condition + "]");
                    comma2 = " ";
                }
                sb.append("}");
            }
            return sb.append(")").toString();
        }

        public boolean isEndState() {
            return this._object != null;
        }
    }

    @ParametersAreNonnullByDefault
    private class NFAStateSet {
        private final HashSet<NFAState> _states;

        private NFAStateSet(HashSet<NFAState> states) {
            this._states = states;
        }

        public NFAStateSet() {
            this(new HashSet<NFAState>());
            pathMatcher._start.collectEpsilon(this._states, null);
        }

        @Nonnull
        public NFAStateSet nextStateSet(PathMatchElement<C> w) {
            HashSet<NFAState> result = new HashSet<NFAState>();
            for (NFAState s : this._states) {
                s.collectNextState(w, result);
            }
            return new NFAStateSet(result);
        }

        @Nonnull
        public Set<NFAState> getStates() {
            return this._states;
        }
    }
}

