/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.pathmatcher;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolContexts;
import de.justsoftware.onx.common.business.configfile.boolexpr.ImmutableBoolContext;
import de.justsoftware.onx.common.business.configfile.pathmatcher.PathMatchElement;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.DynamicAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.AbstractImmutableEqualsObject;
import de.justsoftware.onx.container.shared.model.DefaultItemIdVisitor;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusClientModel;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.PseudoEntityItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.right.Right;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.container.shared.server.model.NewsPostItem;
import de.justsoftware.onx.container.shared.server.model.PseudoEntityItem;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.server.model.FeedItem;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import de.justsoftware.polls.model.pollid.item.PollItem;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

public final class Path
extends AbstractImmutableEqualsObject {
    public static final Path GLOBAL_SETTINGS = Path.builder().add("GLOBAL_SETTINGS").build();
    public static final Path ANY_STARTPAGE = Path.builder().add(ItemType.STARTPAGE.name(), BoolContexts.ALWAYS_TRUE).build();
    public static final Path ANY_PROFILE = Path.builder().add(ItemType.PROFILE.name(), BoolContexts.ALWAYS_TRUE).build();
    public static final Path ANY_ENTITY = Path.builder().add(ItemType.ENTITY.name(), BoolContexts.ALWAYS_TRUE).build();
    private final ImmutableList<PathMatchElement<ImmutableBoolContext>> _path;
    private final String _actionParameter;

    private Path(@Nonnull ImmutableList<PathMatchElement<ImmutableBoolContext>> path, @Nullable String actionParameter) {
        super(path);
        this._path = path;
        this._actionParameter = actionParameter;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public ImmutableList<PathMatchElement<ImmutableBoolContext>> getPath() {
        return this._path;
    }

    @CheckForNull
    public String getActionParameter() {
        return this._actionParameter;
    }

    @Override
    public String toString() {
        String pathString = Joiner.on((char)'/').skipNulls().join(Iterables.transform(this._path, PathMatchElement::getWord));
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)pathString).toString();
    }

    @Nonnull
    private static ImmutableBoolContext createProfileBoolContext(@Nonnull Set<PersonRole> roles) {
        ImmutableSet.Builder roleStrings = ImmutableSet.builder();
        for (PersonRole role : roles) {
            roleStrings.add((Object)role.getNameAndParam());
        }
        return BoolContexts.multiMatch((ImmutableSet<NameAndParam>)roleStrings.build());
    }

    private static final class ItemContextVisitor
    extends ItemVisitor.DefaultItemVisitor<ImmutableBoolContext> {
        private static final String INITIAL_DRAFT = "INITIAL_DRAFT";
        private static final String SCHEDULED_POST = "SCHEDULED_POST";

        private ItemContextVisitor() {
        }

        @Override
        public ImmutableBoolContext visit(EntityItem item) {
            DBEntity entity = item.getEntity();
            ImmutableSet<EntityStatusClientModel> statusList = entity.getEntityStatus();
            if (statusList.isEmpty()) {
                return BoolContexts.singleMatch(entity.getType().getName());
            }
            ImmutableSet.Builder option = ImmutableSet.builder();
            option.add((Object)((NameAndParam)NameAndParam.FROM_STRING_NO_PARAM.apply((Object)entity.getType().getName())));
            for (EntityStatusClientModel status : statusList) {
                option.add((Object)((NameAndParam)NameAndParam.FROM_STRING_NO_PARAM.apply((Object)status.getName())));
            }
            boolean initialDraft = entity.isInitialDraft();
            if (initialDraft) {
                option.add((Object)((NameAndParam)NameAndParam.FROM_STRING_NO_PARAM.apply((Object)INITIAL_DRAFT)));
            }
            return BoolContexts.multiMatch((ImmutableSet<NameAndParam>)option.build());
        }

        @Override
        public ImmutableBoolContext visit(PseudoEntityItem item) {
            return BoolContexts.singleMatch(item.getEntityType().getName());
        }

        @Override
        public ImmutableBoolContext visit(PollItem pollItem) {
            return BoolContexts.EMPTY_CONTEXT;
        }

        @Override
        public ImmutableBoolContext visit(NewsPostItem newsPostItem) {
            return BoolContexts.EMPTY_CONTEXT;
        }

        @Override
        public ImmutableBoolContext visit(ProfileItem profileItem) {
            return Path.createProfileBoolContext(profileItem.getRoles());
        }

        @Override
        public ImmutableBoolContext visit(WorkstreamItem m) {
            if (!m.getMessage().isPublished() && m.getType() == WorkstreamMessageType.MICROBLOG_POSTING) {
                return BoolContexts.singleMatch(SCHEDULED_POST);
            }
            return BoolContexts.singleMatch(m.getType().name());
        }

        @Override
        public ImmutableBoolContext visit(FeedItem feedItem) {
            return BoolContexts.singleMatch(feedItem.getId().getAppId().getId().toUpperCase());
        }

        @Override
        protected ImmutableBoolContext visitDefault(Item<?> item) {
            return BoolContexts.EMPTY_CONTEXT;
        }
    }

    @ParametersAreNonnullByDefault
    private static final class ItemIdPathVisitor
    implements DefaultItemIdVisitor<String> {
        private ItemIdPathVisitor() {
        }

        @Override
        public String visitDefault(ItemId id) {
            return id.getType().name();
        }

        @Override
        public String visit(PseudoEntityItemId id) {
            return ItemType.ENTITY.name();
        }
    }

    public static final class Builder {
        private final ImmutableList.Builder<PathMatchElement<ImmutableBoolContext>> _path = ImmutableList.builder();

        private Builder() {
        }

        @Nonnull
        private Builder add(@Nonnull String s) {
            return this.add(s, BoolContexts.EMPTY_CONTEXT);
        }

        @Nonnull
        public Path buildWithAction(@Nonnull Action a) {
            String actionParameter = a instanceof DynamicAction ? ((DynamicAction)a).getParameter() : null;
            return new Path(this.add(a.getName(), actionParameter).buildPath(), actionParameter);
        }

        @Nonnull
        public Builder add(@Nonnull ComponentType c) {
            return this.add(c.getNameAndParam());
        }

        @Nonnull
        public Builder add(@Nonnull Right r) {
            return this.add(r.getNameAndParam());
        }

        @Nonnull
        private Builder add(@Nonnull NameAndParam nameAndParam) {
            return this.add(nameAndParam.getName(), nameAndParam.getParam());
        }

        @Nonnull
        private Builder add(@Nonnull String name, @Nullable String param) {
            return this.add(name, param != null ? BoolContexts.singleMatch(param) : BoolContexts.EMPTY_CONTEXT);
        }

        @Nonnull
        public Builder addAllChildren() {
            this.add("**");
            return this;
        }

        @Nonnull
        public Builder add(@Nonnull EntityType e) {
            return this.add(ItemType.ENTITY.name(), BoolContexts.singleMatch(e.name()));
        }

        @Nonnull
        public Builder add(@Nonnull EntityStatus status) {
            return this.add(ItemType.ENTITY_VERSION.name(), BoolContexts.singleMatch(status.getName()));
        }

        @Nonnull
        private Builder add(@Nonnull String name, @Nonnull ImmutableBoolContext boolContext) {
            return this.add(new PathMatchElement<ImmutableBoolContext>(name, boolContext));
        }

        @Nonnull
        public Builder add(@Nonnull Item<?> i) {
            return this.add(i.getId().accept(new ItemIdPathVisitor()), i.accept(new ItemContextVisitor()));
        }

        @Nonnull
        public Builder addProfile(@Nonnull Set<PersonRole> roles) {
            return this.add(ItemType.PROFILE.name(), Path.createProfileBoolContext(roles));
        }

        @Nonnull
        public Builder addStartpage() {
            return this.add(ItemType.STARTPAGE.name());
        }

        @Nonnull
        public Builder add(@Nonnull PathMatchElement<ImmutableBoolContext> pathMatchElement) {
            this._path.add(pathMatchElement);
            return this;
        }

        @Nonnull
        public Path build() {
            return new Path(this.buildPath(), null);
        }

        @Nonnull
        private ImmutableList<PathMatchElement<ImmutableBoolContext>> buildPath() {
            return this._path.build();
        }
    }
}

