/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.parser;

import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.ConfJsonNode;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.configfile.parser.ConfFileNode;
import de.justsoftware.onx.common.business.configfile.parser.ConfPathElement;
import de.justsoftware.onx.common.business.configfile.parser.ConfStatement;
import de.justsoftware.onx.container.business.OptionName;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFor
extends ConfStatement {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationFor.class);
    private final List<ConfPathElement> _path;
    private final Map<OptionName<?>, Object> _options = new HashMap();

    public ConfigurationFor(@Nullable ConfFilePosition pos, @Nonnull List<ConfPathElement> path) {
        super(pos);
        this._path = path;
    }

    @Nonnull
    public List<ConfPathElement> getPath() {
        return this._path;
    }

    @Override
    public void addTo(ConfFileNode n) {
        n.addFacilities(this);
    }

    @CheckForNull
    private OptionName<?> getOptionName(@Nonnull String key) {
        OptionName<?> facilityName = OptionName.optionNameForString(key);
        if (facilityName == null) {
            if (OptionName.IGNORED_OPTION_NAMES.contains((Object)key)) {
                LOG.info("The option name \"" + key + "\" is deprecated and ignored. Please remove this value from configuration.");
                return null;
            }
            throw new LoadConfigFileException(this.getPos(), "Unknown FacilityName: [" + key + "]");
        }
        return facilityName;
    }

    public void addOption(@Nonnull String key, @Nonnull ConfJsonNode value, @Nonnull ConfFilePosition pos) {
        OptionName<?> optionName = this.getOptionName(key);
        if (optionName == null) {
            return;
        }
        Object oldVal = this._options.put(optionName, optionName.getOptionType().convert(value));
        if (oldVal != null) {
            throw new LoadConfigFileException(pos, String.format("The setting '%s' is already set in this block", key));
        }
    }

    @CheckForNull
    public <T> T getOption(@Nonnull OptionName<T> optionName) {
        Object result = this._options.get(optionName);
        return (T)result;
    }

    @Nonnull
    public Map<OptionName<?>, Object> getOptions() {
        return Collections.unmodifiableMap(this._options);
    }

    public String toString() {
        return "ConfigurationFor(" + this.getPos() + "," + this._path + ") = \n" + this._options;
    }
}

