/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.parser;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.configfile.parser.ConfFileNode;
import de.justsoftware.onx.common.business.configfile.parser.ConfOptionModifier;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;

public class ConfOption
extends ConfFileNode {
    public static final Function<ConfOption, AuthorityModel> GET_AUTHORITY_MODEL = new Function<ConfOption, AuthorityModel>(){

        public AuthorityModel apply(ConfOption o) {
            return o != null ? new AuthorityModel(o.getName(), o.getModifier().toAuthorityModelModifier()) : null;
        }
    };
    public static final Function<ConfOption, String> GET_OPTION_NAME = new Function<ConfOption, String>(){

        public String apply(ConfOption o) {
            return o != null ? o.getName() : null;
        }
    };
    public static final Function<ConfOption, BoolExpr> GET_EXPR = new NullPermeableFunction<ConfOption, BoolExpr>(){

        @Override
        protected BoolExpr applySafe(ConfOption confOption) {
            return confOption.getExpr();
        }
    };
    public static final Predicate<ConfOption> IS_FORCED = new Predicate<ConfOption>(){

        public boolean apply(ConfOption input) {
            return input != null && input.isForced();
        }
    };
    public static final Predicate<ConfOption> IS_DEFAULT = new Predicate<ConfOption>(){

        public boolean apply(ConfOption input) {
            return input != null && input.isDefault();
        }
    };
    public static final Predicate<ConfOption> IS_PRE_SELECTED = new Predicate<ConfOption>(){

        public boolean apply(ConfOption input) {
            return input != null && input.isPreSelected();
        }
    };
    public static final Predicate<ConfOption> IS_VISIBLE = new Predicate<ConfOption>(){

        public boolean apply(ConfOption input) {
            return input != null && input.isVisible();
        }
    };
    private final ConfOptionModifier _modifier;
    private final String _name;
    private BoolExpr _expr;

    public ConfOption(@Nonnull ConfFilePosition pos, @Nonnull ConfOptionModifier modifier, @Nonnull String name, @Nonnull BoolExpr expr) {
        super(pos);
        this._modifier = modifier;
        this._name = name;
        this._expr = expr;
    }

    @Nonnull
    public ConfOptionModifier getModifier() {
        return this._modifier;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public BoolExpr getExpr() {
        return this._expr;
    }

    public void setExpr(@Nonnull BoolExpr expr) {
        this._expr = expr;
    }

    public String toString() {
        return this._name + "=" + this._expr;
    }

    public boolean isComposed() {
        return !this._name.equals(this._expr.toString());
    }

    public boolean isForced() {
        return this._modifier == ConfOptionModifier.FORCED || this._modifier == ConfOptionModifier.HIDDEN;
    }

    public boolean isDefault() {
        return this._modifier == ConfOptionModifier.DEFAULT;
    }

    public boolean isPreSelected() {
        return this._modifier != ConfOptionModifier.NONE;
    }

    public boolean isVisible() {
        return this._modifier != ConfOptionModifier.HIDDEN;
    }
}

