/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.parser;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import de.justsoftware.onx.common.business.configfile.AbstractConfNode;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConfEntityType
extends AbstractConfNode {
    public static final Function<ConfEntityType, EntityType> GET_ENTITY_TYPE = new Function<ConfEntityType, EntityType>(){

        public EntityType apply(ConfEntityType input) {
            return input != null ? input.getEntityType() : null;
        }
    };
    private final EntityType _entityType;

    public ConfEntityType(@Nullable ConfFilePosition pos, @Nonnull String entityTypeStr) {
        super(pos);
        try {
            this._entityType = EntityType.valueOf(entityTypeStr);
        }
        catch (IllegalArgumentException e) {
            throw new LoadConfigFileException(pos, "Unknown entity type: " + entityTypeStr, e);
        }
    }

    @Nonnull
    public EntityType getEntityType() {
        return this._entityType;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof ConfEntityType && Objects.equal((Object)((ConfEntityType)obj)._entityType, (Object)this._entityType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._entityType});
    }
}

