/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.nodes;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import de.justsoftware.onx.common.business.configfile.AbstractConfJsonNode;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.ConfJsonNode;
import de.justsoftware.onx.container.business.OptionType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListNode
extends AbstractConfJsonNode
implements Iterable<ConfJsonNode> {
    private final List<ConfJsonNode> _delegateList;

    public ListNode(@Nonnull ConfFilePosition pos) {
        this(pos, new ArrayList<ConfJsonNode>());
    }

    public ListNode(@Nullable ConfFilePosition pos, @Nonnull List<ConfJsonNode> list) {
        super(pos);
        this._delegateList = list;
    }

    @Override
    public Iterator<ConfJsonNode> iterator() {
        return this._delegateList.iterator();
    }

    public void add(@Nonnull ConfJsonNode e) {
        this._delegateList.add(e);
    }

    @Nonnull
    public static <E> ListNode newListNode(ConfJsonNode ... args) {
        return new ListNode(null, Lists.newArrayList((Object[])args));
    }

    @Override
    public ListNode assertList() throws OptionType.OptionTypeException {
        return this;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof ListNode && Objects.equal(this._delegateList, ((ListNode)obj)._delegateList);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._delegateList});
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        Joiner.on((String)", ").appendTo(result, this._delegateList);
        result.append("]");
        return result.toString();
    }
}

