/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.business.FileWatchService;
import de.justsoftware.onx.common.business.configfile.ConfFile;
import de.justsoftware.onx.common.business.configfile.ConfigFileChangeEvent;
import de.justsoftware.onx.common.business.configfile.ConfigFileTestService;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.configfile.impl.JuCoConfigFileSource;
import de.justsoftware.onx.common.business.configfile.parser.ConfFileSource;
import de.justsoftware.onx.common.business.configfile.parser.ConfFileUtil;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.container.integration.persistence.EntityDAO;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.integration.persistence.PersonDAO;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="configFileService")
public class ConfigFileServiceImpl
implements ServerEventHandler,
ConfigFileTestService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFileServiceImpl.class);
    private final EntityDAO _entityDAO;
    private final JCEventBus _eventBus;
    private volatile ConfFile _confFile;
    private volatile ImmutableList<ConfFileSource> _sources;
    private boolean _failOnMissingAuthorities;
    private final FileWatchService _fileWatchService;
    private final PersonDAO _personDAO;

    @Autowired
    @ParametersAreNonnullByDefault
    public ConfigFileServiceImpl(EntityDAO entityDAO, PersonDAO personDAO, JCEventBus eventBus, @Value(value="${config.loading.failOnMissingAuthorities}") boolean failOnMissingAuthorities, FileWatchService fileWatchService) {
        this._entityDAO = entityDAO;
        this._personDAO = personDAO;
        this._eventBus = eventBus;
        this._failOnMissingAuthorities = failOnMissingAuthorities;
        this._fileWatchService = fileWatchService;
    }

    @Override
    public void loadConfigFile(String fileName) {
        this.loadConfigFiles(ConfFileUtil.requiredUnwatchedSourceOf(fileName));
    }

    @Override
    public void loadJuCoConfigFiles() throws LoadConfigFileException {
        this.loadConfigFiles(JuCoConfigFileSource.values());
    }

    @Override
    public void loadConfigFiles(ConfFileSource ... sources) {
        ConfFile confFile = ConfFileUtil.load(sources).checkAndAnalyze(this._failOnMissingAuthorities);
        try {
            this._entityDAO.synchronizeEntityTypes((Iterable<? extends EntityType>)confFile.getEntityTypes());
            this._personDAO.synchronizePersonRoles((Set<PersonRole>)confFile.getAllPersonRoles());
        }
        catch (DAOException e) {
            throw new LoadConfigFileException("Unable to synchronize configuration with Database! " + e.getMessage(), (Throwable)e);
        }
        this._confFile = confFile;
        this._sources = ImmutableList.copyOf((Object[])sources);
        this._eventBus.post(ConfigFileChangeEvent.INSTANCE);
    }

    @Override
    public ConfFile getConfigFile() {
        if (this._confFile == null) {
            throw new ServiceException("Config file was not loaded");
        }
        return this._confFile;
    }

    @Override
    public ImmutableList<ConfFileSource> getConfigSources() {
        return this._sources;
    }

    public void setFailOnMissingAuthorities(boolean failOnMissingAuthorities) {
        this._failOnMissingAuthorities = failOnMissingAuthorities;
    }

    @Subscribe
    public void onConfigFileChanged(@Nonnull FileWatchService.FileChangeEvent event) {
        if (FileWatchService.FileChangeEvent.CONFIG_FILE_CHANGED.equals(event)) {
            LOG.info("Config changed on the filesystem, initiate reloading...");
            try {
                this.loadJuCoConfigFiles();
            }
            catch (LoadConfigFileException e) {
                LOG.error("ERROR while reloading config file", (Throwable)e);
            }
            LOG.info("reloading done...");
        }
    }

    public void afterPropertiesSet() {
        this.loadJuCoConfigFiles();
        ConfFileSource[] configFilesToWatch = (ConfFileSource[])Iterables.toArray((Iterable)Iterables.filter(Arrays.asList(JuCoConfigFileSource.values()), (Predicate)new Predicate<ConfFileSource>(){

            public boolean apply(@Nullable ConfFileSource input) {
                return input != null && input.reloadOnChange();
            }
        }), ConfFileSource.class);
        this._fileWatchService.registerWatchesFiles(ConfFileUtil.getConfigFileUrls(configFilesToWatch), FileWatchService.FileChangeEvent.CONFIG_FILE_CHANGED);
    }
}

