/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.boolexpr;

import com.google.common.base.Objects;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExprVisitor;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalContext;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalException;
import de.justsoftware.onx.common.business.configfile.parser.ConfFileNode;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class VarExpr
extends BoolExpr {
    final NameAndParam _nameAndParam;

    VarExpr(@Nullable ConfFilePosition pos, @Nonnull NameAndParam nameAndParam) {
        super(pos);
        this._nameAndParam = nameAndParam;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._nameAndParam});
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof VarExpr && Objects.equal((Object)this._nameAndParam, (Object)((VarExpr)obj)._nameAndParam);
    }

    @Override
    public String toString() {
        String param = this._nameAndParam.getParam();
        if (param == null) {
            return this._nameAndParam.getName();
        }
        return this._nameAndParam.getName() + "(\"" + param + "\")";
    }

    @Override
    public void checkVariables(Set<String> allowedVariables) throws LoadConfigFileException {
        String param = this._nameAndParam.getName();
        if (!allowedVariables.contains(param) && !ConfFileNode.IGNORED_VARIABLES.contains((Object)param)) {
            throw new LoadConfigFileException(this.getPos(), String.format("Variable '%s' is not allowed here. Allowed is %s", param, allowedVariables));
        }
    }

    @Override
    public <T> T accept(BoolExprVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Nonnull
    public NameAndParam getVarName() {
        return this._nameAndParam;
    }

    @Override
    public BoolExpr eval(EvalContext context) throws EvalException {
        return context.eval(this);
    }
}

