/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.boolexpr;

import de.justsoftware.onx.common.business.configfile.boolexpr.AndExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExprVisitor;
import de.justsoftware.onx.common.business.configfile.boolexpr.ConstExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.NotExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.OrExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.VarExpr;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class PredicateBoolExprVisitor
implements BoolExprVisitor<Boolean> {
    private final Predicate<VarExpr> _stopPredicate;

    PredicateBoolExprVisitor(Predicate<VarExpr> stopPredicate) {
        this._stopPredicate = stopPredicate;
    }

    @Override
    public Boolean visit(AndExpr expr) {
        return this.multi(expr._exprs.stream());
    }

    @Nonnull
    private Boolean multi(Stream<BoolExpr> exprs) {
        return exprs.anyMatch(e -> e.accept(this));
    }

    @Override
    public Boolean visit(NotExpr expr) {
        return expr._expr.accept(this);
    }

    @Override
    public Boolean visit(OrExpr expr) {
        return this.multi(expr._exprs.stream());
    }

    @Override
    public Boolean visit(ConstExpr expr) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(VarExpr expr) {
        return this._stopPredicate.test(expr);
    }
}

