/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.boolexpr;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.configfile.AbstractConfNode;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.configfile.boolexpr.AndExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolContext;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExprVisitor;
import de.justsoftware.onx.common.business.configfile.boolexpr.ConstExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalContext;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalException;
import de.justsoftware.onx.common.business.configfile.boolexpr.ImmutableBoolContext;
import de.justsoftware.onx.common.business.configfile.boolexpr.NotExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.OrExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.PredicateBoolExprVisitor;
import de.justsoftware.onx.common.business.configfile.boolexpr.SubstituteBoolExprVisitor;
import de.justsoftware.onx.common.business.configfile.boolexpr.UsedVariablesBoolExprVisitor;
import de.justsoftware.onx.common.business.configfile.boolexpr.VarExpr;
import de.justsoftware.onx.common.shared.model.Authority;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BoolExpr
extends AbstractConfNode {
    public static final Function<BoolExpr, BoolExpr> SIMPLIFY = new NullPermeableFunction<BoolExpr, BoolExpr>(){

        @Override
        protected BoolExpr applySafe(BoolExpr input) {
            return input.simplify();
        }
    };
    public static final Function<BoolExpr, ImmutableSet<NameAndParam>> USED_VARIABLES = new NullPermeableFunction<BoolExpr, ImmutableSet<NameAndParam>>(){

        @Override
        protected ImmutableSet<NameAndParam> applySafe(BoolExpr input) {
            return input.usedVariables();
        }
    };
    public static final BoolExpr FALSE = BoolExpr.falseConst(null);
    public static final BoolExpr TRUE = BoolExpr.trueConst(null);
    public static final Function<BoolExpr, ImmutableSet<NameAndParam>> GET_USED_VARIABLES = new NullPermeableFunction<BoolExpr, ImmutableSet<NameAndParam>>(){

        @Override
        protected ImmutableSet<NameAndParam> applySafe(BoolExpr boolExpr) {
            return boolExpr.usedVariables();
        }
    };

    BoolExpr(@Nullable ConfFilePosition pos) {
        super(pos);
    }

    public final boolean eval(@Nonnull BoolContext context) throws EvalException {
        BoolExpr result = this.eval((VarExpr varExpr) -> context.getValueOf(varExpr.getVarName()) ? TRUE : FALSE);
        if (TRUE.equals(result)) {
            return true;
        }
        if (FALSE.equals(result)) {
            return false;
        }
        throw new EvalException("\"" + result + "\" can't be resolved to true or false");
    }

    @Nonnull
    public abstract BoolExpr eval(@Nonnull EvalContext var1) throws EvalException;

    @Nonnull
    public final BoolExpr simplify() {
        return this.eval(new EvalContext(){

            @Override
            public BoolExpr eval(VarExpr varExpr) {
                return varExpr;
            }
        });
    }

    @Nonnull
    public final BoolExpr substitute(@Nonnull Map<NameAndParam, ? extends BoolExpr> subsMap) {
        return this.substitute((Function<? super NameAndParam, ? extends BoolExpr>)((Function)subsMap::get));
    }

    @Nonnull
    public final BoolExpr substitute(@Nonnull Function<? super NameAndParam, ? extends BoolExpr> substituteFunction) {
        return this.accept(new SubstituteBoolExprVisitor(substituteFunction));
    }

    @Nonnull
    public static Function<BoolExpr, BoolExpr> substitudeFunction(final @Nonnull Map<NameAndParam, ? extends BoolExpr> subsMap) {
        return new NullPermeableFunction<BoolExpr, BoolExpr>(){

            @Override
            protected BoolExpr applySafe(BoolExpr input) {
                return input.substitute(subsMap);
            }
        };
    }

    public abstract void checkVariables(Set<String> var1) throws LoadConfigFileException;

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public abstract int hashCode();

    @Nonnull
    public static BoolExpr and(@Nullable ConfFilePosition pos, BoolExpr ... es) {
        return BoolExpr.and(pos, (Iterable<? extends BoolExpr>)ImmutableSet.copyOf((Object[])es));
    }

    @Nonnull
    public static BoolExpr and(BoolExpr ... es) {
        return BoolExpr.and(null, es);
    }

    @Nonnull
    public static BoolExpr and(@Nullable ConfFilePosition pos, @Nonnull Iterable<? extends BoolExpr> es) {
        Iterator<? extends BoolExpr> it = es.iterator();
        if (!it.hasNext()) {
            return BoolExpr.trueConst(pos);
        }
        BoolExpr first = it.next();
        if (!it.hasNext()) {
            return first;
        }
        return new AndExpr(pos, (ImmutableSet<BoolExpr>)ImmutableSet.copyOf(es));
    }

    @Nonnull
    public static BoolExpr and(@Nonnull Iterable<? extends BoolExpr> es) {
        return BoolExpr.and(null, es);
    }

    @Nonnull
    public static ConstExpr trueConst(@Nullable ConfFilePosition pos) {
        return new ConstExpr(pos, true);
    }

    @Nonnull
    public static ConstExpr falseConst(@Nullable ConfFilePosition pos) {
        return new ConstExpr(pos, false);
    }

    @Nonnull
    public static NotExpr not(@Nullable ConfFilePosition pos, @Nonnull BoolExpr e) {
        return new NotExpr(pos, e);
    }

    @Nonnull
    public static NotExpr not(@Nonnull BoolExpr e) {
        return BoolExpr.not(null, e);
    }

    @Nonnull
    public static VarExpr var(@Nullable ConfFilePosition pos, @Nonnull String varName) {
        return BoolExpr.var(pos, varName, null);
    }

    @Nonnull
    public static VarExpr var(@Nullable ConfFilePosition pos, @Nonnull String varName, @Nullable String param) {
        return BoolExpr.var(pos, new NameAndParam(varName, param));
    }

    @Nonnull
    public static VarExpr var(@Nonnull Authority authority) {
        return BoolExpr.var(authority.getNameAndParam());
    }

    @Nonnull
    public static VarExpr var(@Nonnull NameAndParam nameAndParam) {
        return BoolExpr.var(null, nameAndParam);
    }

    @Nonnull
    private static VarExpr var(@Nullable ConfFilePosition pos, @Nonnull NameAndParam nameAndParam) {
        return new VarExpr(pos, nameAndParam);
    }

    @Nonnull
    public static BoolExpr var(@Nonnull String varName) {
        return BoolExpr.var(null, varName);
    }

    @Nonnull
    public static BoolExpr or(@Nullable ConfFilePosition pos, BoolExpr ... es) {
        return BoolExpr.or(pos, (Iterable<? extends BoolExpr>)ImmutableSet.copyOf((Object[])es));
    }

    @Nonnull
    public static BoolExpr or(@Nullable ConfFilePosition pos, @Nonnull Iterable<? extends BoolExpr> es) {
        Iterator<? extends BoolExpr> it = es.iterator();
        if (!it.hasNext()) {
            return BoolExpr.falseConst(pos);
        }
        BoolExpr first = it.next();
        if (!it.hasNext()) {
            return first;
        }
        return new OrExpr(pos, (ImmutableSet<BoolExpr>)ImmutableSet.copyOf(es));
    }

    @Nonnull
    public static BoolExpr or(BoolExpr ... es) {
        return BoolExpr.or(null, es);
    }

    @Nonnull
    public static BoolExpr or(@Nonnull Iterable<? extends BoolExpr> es) {
        return BoolExpr.or(null, es);
    }

    @VisibleForTesting
    public static boolean boolEquals(@Nonnull BoolExpr a, @Nonnull BoolExpr b) {
        HashSet<NameAndParam> vars = new HashSet<NameAndParam>();
        vars.addAll((Collection<NameAndParam>)a.usedVariables());
        vars.addAll((Collection<NameAndParam>)b.usedVariables());
        if (vars.size() > 16) {
            throw new IllegalArgumentException("Only 16 varibales are allowed");
        }
        ImmutableMap.Builder varBitsBuilder = ImmutableMap.builder();
        int bit = 1;
        for (NameAndParam var : vars) {
            varBitsBuilder.put((Object)var, (Object)bit);
            bit <<= 1;
        }
        int maxCount = bit;
        ImmutableMap varBits = varBitsBuilder.build();
        for (int i = 0; i < maxCount; ++i) {
            EqualsContext context = new EqualsContext((ImmutableMap<NameAndParam, Integer>)varBits, i);
            try {
                if (a.eval(context) == b.eval(context)) continue;
                return false;
            }
            catch (EvalException e) {
                throw new IllegalStateException("this should never happen");
            }
        }
        return true;
    }

    @Nonnull
    public final ImmutableSet<NameAndParam> usedVariables() {
        return this.accept(UsedVariablesBoolExprVisitor.INSTANCE);
    }

    public boolean test(@Nonnull Predicate<VarExpr> stopPredicate) {
        return this.accept(new PredicateBoolExprVisitor(stopPredicate));
    }

    @Nonnull
    public abstract <T> T accept(@Nonnull BoolExprVisitor<T> var1);

    @Nonnull
    public static BoolExpr valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Nonnull
    public static BoolExpr valueOf(@Nullable Boolean b) {
        return BoolExpr.valueOf(Boolean.TRUE.equals(b));
    }

    private static final class EqualsContext
    implements ImmutableBoolContext {
        private final ImmutableMap<NameAndParam, Integer> _varBits;
        private final int _i;
        private final Object[] _hashObjects;

        public EqualsContext(@Nonnull ImmutableMap<NameAndParam, Integer> varBits, int i) {
            this._varBits = varBits;
            this._i = i;
            this._hashObjects = new Object[]{varBits, i};
        }

        @Override
        public boolean getValueOf(NameAndParam variableName) throws EvalException {
            return ((Integer)this._varBits.get((Object)variableName) & this._i) != 0;
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this._hashObjects);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || obj != null && obj instanceof EqualsContext && Arrays.equals(this._hashObjects, ((EqualsContext)obj)._hashObjects);
        }
    }
}

