/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.components.impl;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.components.TeaserModuleHandler;
import de.justsoftware.onx.common.business.configfile.ConfFile;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.ChildEntitiesTeaserModuleData;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.DefaultComponentTypeVisitor;
import de.justsoftware.onx.container.business.OptionName;
import de.justsoftware.onx.container.shared.model.ChildEntityTeaserSortType;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.searchnew.business.CommonSearchService;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PublicationDateFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TeaserModuleHandlerImpl
implements TeaserModuleHandler {
    @Autowired
    private ConfigFileService _configFileService;
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private CommonSearchService _searchService;

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, EntityItem entity, ComponentType componentType) {
        Path optionsPath = Path.builder().add(entity).add(componentType).build();
        ConfFile configFile = this._configFileService.getConfigFile();
        int numberOfTeasers = configFile.getConfigurationFor(optionsPath, OptionName.AMOUNT_OF_TEASERS_IN_CHILD_PREVIEW).intValue();
        ChildEntityTeaserSortType sortOrder = configFile.getConfigurationFor(optionsPath, OptionName.CHILD_ENTITY_TEASER_SORT_ORDER);
        EntityType teaserType = (EntityType)componentType.accept(new DefaultComponentTypeVisitor<Optional<EntityType>>(){

            @Override
            public Optional<EntityType> visitChildEntities(EntityType entityType) {
                return Optional.of((Object)entityType);
            }

            @Override
            protected Optional<EntityType> visitDefault() {
                return Optional.absent();
            }
        }).orNull();
        boolean hasData = false;
        if (teaserType != null) {
            ListAndCount<EntityId> ids;
            ImmutableSet.Builder subFilters = ImmutableSet.builder().add((Object)new PublicationDateFilter()).add((Object)ArchiveSubFilter.NON_ARCHIVED);
            if (!this._entityConfigService.getDurationTimeOption(teaserType).equals((Object)EntityDurationTimeOption.OFF)) {
                subFilters.add((Object)DateSubFilter.FUTURE);
            }
            hasData = (ids = this._searchService.getVisibleChildrenIds(authorizationContext, entity.getId(), (Iterable<EntityType>)ImmutableSet.of((Object)teaserType), 0, 1, null, (Iterable<? extends SubFilter>)subFilters.build())).getMaxCount() > 0;
        }
        return new ChildEntitiesTeaserModuleData(numberOfTeasers, sortOrder, hasData);
    }

    @Override
    public void create(ComponentType componentType, Iterable<DBEntity> entities, ServerEventCollector eventCollector) {
    }
}

