/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfiguration {
    private static final int CONNECTION_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(10L);
    private static final int READ_TIMEOUT_MILLIS = (int)TimeUnit.MINUTES.toMillis(10L);

    @Bean
    @Nonnull
    public RestTemplate defaultRestTemplate() {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setBufferRequestBody(false);
        requestFactory.setReadTimeout(READ_TIMEOUT_MILLIS);
        requestFactory.setConnectTimeout(CONNECTION_TIMEOUT_MILLIS);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }
}

