/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business;

import com.freiheit.toro.server.business.event.FlushCacheEvent;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.propeye.converter.model.PropertyConverter;
import de.justsoftware.propeye.handler.AbstractPropertiesHandler;
import de.justsoftware.propeye.handler.InitPropertyException;
import de.justsoftware.propeye.property.Properties;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service(value="resourceBundlePropertyHandler")
@ParametersAreNonnullByDefault
public class ResourceBundlePropertyHandler
extends AbstractPropertiesHandler
implements ServerEventHandler {
    private final Map<String, String> _default = new HashMap<String, String>();
    private final ReloadableResourceBundleMessageSource _messageSource = ResourceBundlePropertyHandler.messageSource("locales/toro", "locales/toro_standard");

    public String getPropertyStringRepresentation(Class<? extends Properties> clazz, String key, String domain) {
        try {
            return this._messageSource.getMessage(key, null, new Locale(domain));
        }
        catch (NoSuchMessageException e) {
            return this._default.getOrDefault(key, "No translation for '" + key + "' found.");
        }
    }

    public void initProperty(Class<? extends Properties> clazz, String key, String defaultStringValue, String description, Class<?> returnType, Class<? extends PropertyConverter<?>> converterClass, String converterConfigString, String arraySeparator) throws InitPropertyException {
        super.initProperty(clazz, key, defaultStringValue, description, returnType, converterClass, converterConfigString, arraySeparator);
        this._default.put(key, defaultStringValue);
    }

    private static ReloadableResourceBundleMessageSource messageSource(String ... basenames) {
        ReloadableResourceBundleMessageSource source = new ReloadableResourceBundleMessageSource();
        source.setDefaultEncoding("UTF-8");
        source.setBasenames(basenames);
        source.setFallbackToSystemLocale(false);
        source.setDefaultLocale(Locale.ENGLISH);
        source.setUseCodeAsDefaultMessage(false);
        return source;
    }

    @Subscribe
    public void onFlushCacheEvent(@Nonnull FlushCacheEvent event) {
        this._messageSource.clearCacheIncludingAncestors();
    }
}

