/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business;

import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.JCMediaContentId;
import de.justsoftware.onx.common.shared.model.Link;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.document.shared.model.DocumentId;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.net.MalformedURLException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface InternalLinkService {
    @Nonnull
    public Link linkToItem(Item<?> var1, AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public Link linkToItemAbsolute(Item<?> var1, AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public String makeURL(String var1);

    @Nonnull
    public String makePath(String var1);

    @Nonnull
    public String getImageUrl(AlbumImageId var1, LinkType var2);

    @Nonnull
    public String getAlbumUrl(AlbumId var1, LinkType var2);

    @CheckForNull
    public String getProfileUrl(@Nullable PersonId var1, LinkType var2);

    @CheckForNull
    public String getProfileUrl(@Nullable DBPerson var1, LinkType var2);

    @Nonnull
    public String getEntityUrl(EntityId var1, LinkType var2);

    @Nonnull
    public String getDocumentUrl(DocumentId var1, LinkType var2);

    @Nonnull
    public String getVideoUrl(VideolinkId var1, LinkType var2);

    @Nonnull
    public String getUrlForMicroblogEntry(WorkstreamMessageId var1, LinkType var2);

    @Nonnull
    public String getSurveyUrl(SurveyId var1, LinkType var2);

    @Nonnull
    public String makeRelativeUrlAbsolute(String var1) throws MalformedURLException;

    @Nonnull
    public String getWorkstreamAttachmentUrl(WorkstreamMessageId var1, JCMediaContentId var2);

    @Nonnull
    public String makeAbsolute(String var1);

    @Nonnull
    public String addHost(String var1);

    @Nonnull
    public String getDriveDocumentUrl(DriveDocumentId var1, LinkType var2);

    @Nonnull
    public String getDriveDocumentUrl(DriveDocumentItem var1, LinkType var2);

    @Nonnull
    public String getDriveDocumentCommentsUrl(DriveDocumentItem var1, LinkType var2);

    public static enum LinkType {
        URL,
        PATH,
        FRAGMENT;

    }
}

