/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheKey;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.util.ObjectUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import de.justsoftware.common.concurent.CollectedBooleanFuture;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.common.business.CacheMissHandler;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class CacheHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CacheHelper.class);
    @Autowired
    private MemcachedClientCache _cache;

    public <T> T getFromCache(CacheKey cacheKey, CacheMissHandler<T> callback) {
        return this.getFromCache(cacheKey, CacheClient.DEFAULT_LIFETIME, callback);
    }

    public <T> T getFromCache(CacheKey cacheKey, long expires, CacheMissHandler<T> callback) {
        Object result = this._cache.get(cacheKey.getCacheName(), cacheKey.getKey());
        if (result == null) {
            result = callback.handleCacheMiss();
            this._cache.add(cacheKey.getCacheName(), cacheKey.getKey(), result, expires);
        }
        return result;
    }

    @Nonnull
    public <I, D> List<D> getByIdsList(Collection<I> idsWithNull, GetByIdsInterface<I, D> functions) {
        Map<I, D> data = this.getByIdsMap(idsWithNull, functions);
        ArrayList<D> result = new ArrayList<D>();
        for (I id : idsWithNull) {
            if (id == null) {
                result.add(null);
                continue;
            }
            result.add(data.get(id));
        }
        return result;
    }

    @Nonnull
    public <I, D> Map<I, D> getByIdsMap(Iterable<? extends I> idsWithNull, GetByIdsInterface<I, D> functions) {
        HashSet ids = Sets.newHashSet();
        HashMap idsByCacheKey = Maps.newHashMap();
        CacheName name = null;
        for (I id : idsWithNull) {
            if (id == null) continue;
            ids.add(id);
            CacheKey cacheKey = functions.cacheKey(id);
            idsByCacheKey.put(cacheKey.getKey(), id);
            if (name == null) {
                name = cacheKey.getCacheName();
                continue;
            }
            if (name.equals(cacheKey.getCacheName())) continue;
            throw new IllegalStateException();
        }
        return this.getByIdsMapInternal(ids, name, idsByCacheKey, functions);
    }

    @Nonnull
    private <I, D> Map<I, D> getByIdsMapInternal(HashSet<I> ids, CacheName name, Map<String, I> idsByCacheKey, GetByIdsInterface<I, D> functions) {
        if (ids.isEmpty()) {
            return ImmutableMap.of();
        }
        Map cacheData = this._cache.getBulk(name, idsByCacheKey.keySet());
        HashMap<I, Object> result = new HashMap<I, Object>();
        for (Map.Entry cacheEntry : cacheData.entrySet()) {
            I key = idsByCacheKey.get(cacheEntry.getKey());
            if (key == null && !idsByCacheKey.containsKey(null)) continue;
            Object value = cacheEntry.getValue();
            if (value != null) {
                result.put(key, value);
            }
            ids.remove(key);
        }
        if (ids.isEmpty()) {
            return result;
        }
        Map<I, D> db = functions.ibatisGetByIds(ids);
        for (Map.Entry<I, D> dbEntry : db.entrySet()) {
            I key = dbEntry.getKey();
            D value = dbEntry.getValue();
            if (ids.contains(key) && value != null) {
                result.put(key, value);
            }
            CacheKey cacheKey = functions.cacheKey(key);
            this._cache.add(cacheKey.getCacheName(), cacheKey.getKey(), value);
        }
        return result;
    }

    @Nonnull
    public <I, D, M, P, A extends AuthorizationCheckContext> ListAndCount<M> getListAndCount(P parameter, int offset, int limit, GetByOffsetLimitInterface<I, D, M, P, A> functions, A authorizationContext) {
        List<I> ids = functions.getIds(parameter);
        List<D> ds = this.getByIdsList(CollectionUtil.subList(ids, offset, offset + limit), functions);
        ListAndCount ms = new ListAndCount(ds.size());
        ms.setMaxCount(ids.size());
        Iterables.addAll(ms, functions.map(Iterables.filter(ds, (Predicate)Predicates.notNull()), authorizationContext));
        return ms;
    }

    public void delete(CacheKey cacheKey) {
        try {
            this._cache.delete(cacheKey.getCacheName(), cacheKey.getKey()).get();
        }
        catch (InterruptedException e) {
            LOG.warn("We got interrupted while wating for a delete", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error("We got an error while wating for a delete", (Throwable)e);
            throw new ServiceException(e);
        }
    }

    public void delete(ImmutableSet<CacheKey> cacheKeys) {
        try {
            ImmutableListMultimap keysByCache = Multimaps.index((Iterable)Iterables.filter(cacheKeys, (Predicate)Predicates.notNull()), (Function)new Function<CacheKey, CacheName>(){

                public CacheName apply(CacheKey input) {
                    return ObjectUtil.checkNotNull(input).getCacheName();
                }
            });
            LinkedList futures = Lists.newLinkedList();
            for (CacheName cache : keysByCache.keySet()) {
                ImmutableList keys = keysByCache.get((Object)cache);
                futures.add(this._cache.deleteKeys(cache, Iterables.filter((Iterable)Iterables.transform((Iterable)keys, CacheKey.TO_KEY_STRING), (Predicate)Predicates.notNull())));
            }
            new CollectedBooleanFuture(futures).get();
        }
        catch (InterruptedException e) {
            LOG.warn("We got interrupted while wating for a delete", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error("We got an error while wating for a delete", (Throwable)e);
            throw new ServiceException(e);
        }
    }

    @Nonnull
    public Future<Boolean> asyncDelete(CacheKey cacheKey) {
        return this._cache.delete(cacheKey.getCacheName(), cacheKey.getKey());
    }

    public static interface GetByOffsetLimitInterface<I, D, M, P, A extends AuthorizationCheckContext>
    extends GetByIdsInterface<I, D> {
        public List<I> getIds(P var1);

        @Nonnull
        public Iterable<M> map(@Nonnull Iterable<D> var1, @Nonnull A var2);
    }

    public static interface GetByIdsInterface<I, D> {
        public CacheKey cacheKey(I var1);

        public Map<I, D> ibatisGetByIds(Set<I> var1);
    }
}

