/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.comments.shared.model.GenericComment;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;

public class CommentItem
implements Item<CommentId> {
    public static final Function<DBComment, CommentItem> FROM_DB_COMMENT = new NullPermeableFunction<DBComment, CommentItem>(){

        @Override
        protected CommentItem applySafe(DBComment input) {
            return new CommentItem(input);
        }
    };
    public static final Function<GenericComment, CommentItem> FROM_GENERIC_COMMENT = new NullPermeableFunction<GenericComment, CommentItem>(){

        @Override
        protected CommentItem applySafe(GenericComment input) {
            return new CommentItem(input);
        }
    };
    private final CommentId _id;
    private final ItemId _parent;
    private final PersonId _author;

    public CommentItem(@Nonnull DBComment comment) {
        this._id = comment.getId();
        this._parent = comment.getParentId();
        this._author = comment.getAuthorId();
    }

    public CommentItem(@Nonnull GenericComment comment) {
        this._id = comment.getId();
        this._parent = comment.getParentId();
        this._author = comment.getAuthorId();
    }

    @Override
    public CommentId getId() {
        return this._id;
    }

    @Override
    public ItemId getParentId() {
        return this._parent;
    }

    public PersonId getAuthorId() {
        return this._author;
    }

    @Override
    public ComponentType getModuleType() {
        return null;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("parent", (Object)this._parent).add("author", (Object)this._author).toString();
    }
}

