/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.shared.model.db;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DBComment
implements Serializable,
Identifiable<CommentId> {
    public static final Function<DBComment, PersonId> GET_AUTHOR_ID = new NullPermeableFunction<DBComment, PersonId>(){

        @Override
        protected PersonId applySafe(DBComment input) {
            return input.getAuthorId();
        }
    };
    private static final long serialVersionUID = 1L;
    private CommentId _id;
    private PersonId _authorId;
    private String _text;
    private String _editorModel;
    private Date _postedAt;
    private ItemId _parentId;
    private String _customInfo;
    private PersonId _editorId;
    private Date _editedAt;

    @Deprecated
    public DBComment() {
    }

    public DBComment(@Nonnull Date postedAt) {
        this._postedAt = Dates.clone(postedAt);
    }

    public void setAuthorId(PersonId authorId) {
        this._authorId = authorId;
    }

    public PersonId getAuthorId() {
        return this._authorId;
    }

    public void setId(CommentId id) {
        this._id = id;
    }

    @Override
    public CommentId getId() {
        return this._id;
    }

    public void setText(String text) {
        this._text = text;
    }

    public String getText() {
        return this._text;
    }

    @CheckForNull
    public String getEditorModel() {
        return this._editorModel;
    }

    public void setEditorModel(@Nullable String editorModel) {
        this._editorModel = editorModel;
    }

    public void setPostedAt(Date postedAt) {
        this._postedAt = Dates.clone(postedAt);
    }

    public Date getPostedAt() {
        return Dates.clone(this._postedAt);
    }

    public void setParentId(ItemId parentId) {
        this._parentId = parentId;
    }

    public ItemId getParentId() {
        return this._parentId;
    }

    public void setCustomInfo(String customInfo) {
        this._customInfo = customInfo;
    }

    public String getCustomInfo() {
        return this._customInfo;
    }

    @CheckForNull
    public PersonId getEditorId() {
        return this._editorId;
    }

    public void setEditorId(@Nullable PersonId editorId) {
        this._editorId = editorId;
    }

    @CheckForNull
    public Date getEditedAt() {
        return Dates.clone(this._editedAt);
    }

    public void setEditedAt(@Nullable Date editedAt) {
        this._editedAt = Dates.clone(editedAt);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("authorId", (Object)this._authorId).add("text", (Object)this._text).add("postedAt", (Object)this._postedAt).add("parentId", (Object)this._parentId).add("customInfo", (Object)this._customInfo).add("editedAt", (Object)this._editedAt).add("editorId", (Object)this._editorId).toString();
    }
}

