/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.comments.business.CommentsDeletionHandler;
import de.justsoftware.onx.comments.business.CommentsService;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommentsDeletionHandlerImpl
implements CommentsDeletionHandler {
    @Autowired
    private CommentsService _commentsService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext context) {
        ImmutableSet.Builder commentIdsToDeleteBuilder = ImmutableSet.builder();
        ImmutableSet.Builder parentIdsWithDeletedCommentsBuilder = ImmutableSet.builder();
        ImmutableSetMultimap<ItemId, CommentId> comments = this._commentsService.getCommentIdsByParentIds(parentIds);
        for (Map.Entry entry : comments.entries()) {
            ItemId parentId = (ItemId)entry.getKey();
            CommentId commentId = (CommentId)entry.getValue();
            if (context.isItemDeleted(commentId)) continue;
            context.addDeletedItem(commentId);
            commentIdsToDeleteBuilder.add((Object)commentId);
            parentIdsWithDeletedCommentsBuilder.add((Object)parentId);
        }
        ImmutableSet commentIdsToDelete = commentIdsToDeleteBuilder.build();
        this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)commentIdsToDelete, context);
        ImmutableSet parentIdsWithDeletedComments = parentIdsWithDeletedCommentsBuilder.build();
        this._commentsService.deleteDependentComments((Set<CommentId>)commentIdsToDelete, (Set<? extends ItemId>)parentIdsWithDeletedComments, context);
    }
}

