/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.freiheit.toro.common.shared.model.ServiceException;
import de.justsoftware.onx.chat.business.ChatServiceInternalApiConnector;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.PersonId;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@Service(value="chatServiceInternalApiConnector")
@ParametersAreNonnullByDefault
public class ChatServiceInternalApiConnectorImpl
implements ChatServiceInternalApiConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChatServiceInternalApiConnectorImpl.class);
    private final String _chatServiceInternalApiUrl;
    private final RestOperations _restTemplate;

    @Autowired
    public ChatServiceInternalApiConnectorImpl(@Value(value="${just-chat-service.internalApi.url}") String chatServiceInternalApiUrl, @Qualifier(value="defaultRestTemplate") RestOperations restTemplate) {
        this._chatServiceInternalApiUrl = chatServiceInternalApiUrl;
        this._restTemplate = restTemplate;
    }

    @Override
    public void clearAndSyncChatNodes() {
        try {
            this._restTemplate.postForLocation(this._chatServiceInternalApiUrl + "/xmpp/resyncChatNodes", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw ChatServiceInternalApiConnectorImpl.logAndThrow("Failed to resync chat nodes via chat-service internal api.", e);
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            this.checkHealth();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void publishAllPermissions() {
        try {
            this._restTemplate.postForLocation(this._chatServiceInternalApiUrl + "/publish/permissions", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw ChatServiceInternalApiConnectorImpl.logAndThrow("Failed to publish all chat participants permission via chat-service internal api.", e);
        }
    }

    @Override
    public void reindexAll() {
        try {
            this._restTemplate.postForLocation(this._chatServiceInternalApiUrl + "/search/reindexAll", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw ChatServiceInternalApiConnectorImpl.logAndThrow("Failed to reindex all chats and messages via chat-service internal api.", e);
        }
    }

    @Override
    public void reindexChatsInCommonCore() {
        try {
            this._restTemplate.postForLocation(this._chatServiceInternalApiUrl + "/search/reindexChatsInCommonCore", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw ChatServiceInternalApiConnectorImpl.logAndThrow("Failed to reindex all chats in common core via chat-service internal api.", e);
        }
    }

    @Override
    public void reindexChatCore() {
        try {
            this._restTemplate.postForLocation(this._chatServiceInternalApiUrl + "/search/reindexChatCore", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw ChatServiceInternalApiConnectorImpl.logAndThrow("Failed to reindex the chat core via chat-service internal api.", e);
        }
    }

    @Override
    public void checkHealth() {
        try {
            this._restTemplate.getForEntity(this._chatServiceInternalApiUrl + "/monitoring/health", JsonNode.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            throw new ServiceException("Chat-Service health check returned status: " + e.getMessage() + " (" + e.getResponseBodyAsString() + ")");
        }
    }

    @Override
    public Map<PersonId, Boolean> getChatEmailNotificationSettings(Set<PersonId> personIds) {
        if (personIds.isEmpty()) {
            return new HashMap<PersonId, Boolean>();
        }
        try {
            ParameterizedTypeReference<HashMap<Long, Boolean>> responseType = new ParameterizedTypeReference<HashMap<Long, Boolean>>(){};
            RequestEntity request = ((RequestEntity.BodyBuilder)RequestEntity.post((URI)URI.create(this._chatServiceInternalApiUrl + "/settings/chatNotifications")).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(personIds.stream().map(LongId::idAsLongValue).collect(Collectors.toList()));
            HashMap<PersonId, Boolean> resultMap = new HashMap<PersonId, Boolean>();
            Map chatNotificationSettings = (Map)this._restTemplate.exchange(request, (ParameterizedTypeReference)responseType).getBody();
            if (chatNotificationSettings != null) {
                chatNotificationSettings.forEach((key, value) -> resultMap.put(PersonId.valueOf(key), (Boolean)value));
            }
            return resultMap;
        }
        catch (RestClientException e) {
            throw ChatServiceInternalApiConnectorImpl.logAndThrow("Failed to retrieve chat notification settings via chat-service internal api.", e);
        }
    }

    @Override
    public void enableChatEmailNotifications(PersonId personId) {
        try {
            this._restTemplate.postForLocation(this._chatServiceInternalApiUrl + "/settings/chatNotifications/" + personId.idAsLongValue() + "/enable", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw ChatServiceInternalApiConnectorImpl.logAndThrow("Failed to enable chat notifications via chat-service internal api.", e);
        }
    }

    @Override
    public void disableChatEmailNotifications(PersonId personId) {
        try {
            this._restTemplate.postForLocation(this._chatServiceInternalApiUrl + "/settings/chatNotifications/" + personId.idAsLongValue() + "/disable", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw ChatServiceInternalApiConnectorImpl.logAndThrow("Failed to disable chat notifications via chat-service internal api.", e);
        }
    }

    @Nonnull
    private static ServiceException logAndThrow(String msg, @Nullable Throwable e) {
        LOGGER.error(msg, e);
        return new ServiceException(msg + "See log for more details.", e);
    }
}

