/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.integration.persistence.ibatis;

import de.justsoftware.onx.calendar.integration.persistence.CalendarFeedDAO;
import de.justsoftware.onx.calendar.server.model.DBICalAccessToken;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisCalendarFeedDAO
implements CalendarFeedDAO {
    private static final Logger LOG = LoggerFactory.getLogger(IbatisCalendarFeedDAO.class);
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisCalendarFeedDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("Calendar");
    }

    @Override
    public int createICalAccessToken(String token, PersonId personId) {
        try {
            this._statementBuilder.insert("insertICalAccessToken").param("token", token, "personId", personId);
            return 1;
        }
        catch (DAOException e) {
            LOG.error("Error inserting ical access token {} : {}", (Object)token, (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public int invalidateICalAccessToken(PersonId personId) {
        try {
            return this._statementBuilder.delete("deleteICalAccessToken").param(personId);
        }
        catch (DAOException e) {
            LOG.error("Error deleting ical access token for person {} : {}", (Object)personId, (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public DBICalAccessToken getAccessTokenByTokenId(String token) {
        return (DBICalAccessToken)this._statementBuilder.select("getPersonIdByToken").param(token).singleObject();
    }

    @Override
    public DBICalAccessToken getAccessTokenByPersonId(PersonId personId) {
        return (DBICalAccessToken)this._statementBuilder.select("getTokenByPersonId").param(personId).singleObject();
    }

    @Override
    public void updateTokenStatus(PersonId personId, boolean active) {
        this._statementBuilder.update("updateTokenStatus").param("personId", personId, "active", active);
    }
}

