/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.business.impl;

import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import de.justsoftware.onx.calendar.business.CalendarFeedReadDataService;
import de.justsoftware.onx.calendar.business.CalendarFeedWriteDataService;
import de.justsoftware.onx.calendar.integration.persistence.CalendarFeedDAO;
import de.justsoftware.onx.calendar.server.model.DBICalAccessToken;
import de.justsoftware.onx.common.cache.AbstractSingleLoadingCacheAccessor;
import de.justsoftware.onx.common.shared.model.PersonId;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class CalendarFeedReadWriteDataServiceImpl
implements CalendarFeedReadDataService,
CalendarFeedWriteDataService {
    private final CalendarFeedDAO _calendarDAO;
    private final TokenByPersonIdCacheAccessor _tokenByPersonIdCacheAccessor;
    private final PersonIdByTokenCacheAccessor _personIdByTokenCacheAccessor;

    @Autowired
    public CalendarFeedReadWriteDataServiceImpl(CalendarFeedDAO calendarDAO, EhcacheClient ehCacheClient) {
        this._calendarDAO = calendarDAO;
        this._tokenByPersonIdCacheAccessor = new TokenByPersonIdCacheAccessor(ehCacheClient, calendarDAO);
        this._personIdByTokenCacheAccessor = new PersonIdByTokenCacheAccessor(ehCacheClient, calendarDAO);
    }

    @Override
    public int createICalAccessToken(String newToken, PersonId personId) {
        int result = this._calendarDAO.createICalAccessToken(newToken, personId);
        this._tokenByPersonIdCacheAccessor.invalidateKey(personId);
        this._personIdByTokenCacheAccessor.invalidateAll();
        return result;
    }

    @Override
    public void invalidateICalAccessToken(PersonId personId) {
        this._calendarDAO.invalidateICalAccessToken(personId);
        this._tokenByPersonIdCacheAccessor.invalidateKey(personId);
        this._personIdByTokenCacheAccessor.invalidateAll();
    }

    @Override
    public DBICalAccessToken getTokenByPersonId(PersonId personId) {
        return (DBICalAccessToken)this._tokenByPersonIdCacheAccessor.getSingle(personId);
    }

    @Override
    public DBICalAccessToken getPersonIdByToken(String token) {
        return (DBICalAccessToken)this._personIdByTokenCacheAccessor.getSingle(token);
    }

    @Override
    public void updateTokenStatus(PersonId personId, boolean active) {
        this._calendarDAO.updateTokenStatus(personId, active);
        this._tokenByPersonIdCacheAccessor.invalidateKey(personId);
        this._personIdByTokenCacheAccessor.invalidateAll();
    }

    @ParametersAreNonnullByDefault
    private static final class PersonIdByTokenCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<CalendarFeedServiceEhCacheName, String, DBICalAccessToken> {
        private final CalendarFeedDAO _dao;

        private PersonIdByTokenCacheAccessor(EhcacheClient cache, CalendarFeedDAO dao) {
            super(cache, CalendarFeedServiceEhCacheName.PERSON_ID_BY_TOKEN);
            this._dao = dao;
        }

        @Override
        protected DBICalAccessToken getFromDatabaseSingle(String token) {
            return this._dao.getAccessTokenByTokenId(token);
        }

        @Override
        protected String keyToString(String token) {
            return token;
        }
    }

    @ParametersAreNonnullByDefault
    private static final class TokenByPersonIdCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<CalendarFeedServiceEhCacheName, PersonId, DBICalAccessToken> {
        private final CalendarFeedDAO _dao;

        private TokenByPersonIdCacheAccessor(EhcacheClient cache, CalendarFeedDAO dao) {
            super(cache, CalendarFeedServiceEhCacheName.TOKEN_BY_PERSON_ID);
            this._dao = dao;
        }

        @Override
        protected DBICalAccessToken getFromDatabaseSingle(PersonId id) {
            return this._dao.getAccessTokenByPersonId(id);
        }

        @Override
        protected String keyToString(PersonId id) {
            return id.toString();
        }
    }

    @ParametersAreNonnullByDefault
    public static enum CalendarFeedServiceEhCacheName implements EhCacheName
    {
        TOKEN_BY_PERSON_ID("CalendarService.tokenByPersonId"),
        PERSON_ID_BY_TOKEN("CalendarService.personIdByToken");

        private final String _prefix;

        private CalendarFeedServiceEhCacheName(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public String getCacheName() {
            return this._prefix;
        }
    }
}

