/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.ItemPathHelper;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.authorization.business.impl.CalculationContext;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.configfile.ConfFile;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.configfile.parser.ConfOption;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.common.shared.model.Authority;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.server.model.DBPrivacySelection;
import de.justsoftware.onx.container.shared.model.AbstractImmutableEqualsObject;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberWorkflow;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityComponent;
import de.justsoftware.onx.container.shared.model.db.DBEntityLinkedEntityPrivacy;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.container.shared.model.right.DefaultRightVisitor;
import de.justsoftware.onx.container.shared.model.right.DynamicRight;
import de.justsoftware.onx.container.shared.model.right.Right;
import de.justsoftware.onx.container.shared.model.right.Rights;
import de.justsoftware.onx.container.shared.model.right.StaticRight;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionSectionId;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersion;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersionSection;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.survey.business.SurveyService;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.server.model.SurveyItem;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.polls.model.pollid.item.PollItem;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="authorizationRightsService")
public class RightsService {
    private static final Logger LOG = LoggerFactory.getLogger(RightsService.class);
    @Autowired
    private EntityService _entityService;
    @Autowired
    private SurveyService _surveyService;
    @Autowired
    private Settings _settings;
    @Autowired
    private ConfigFileService _configFileService;
    @Autowired
    private EntityConfigService _entityConfig;
    @Autowired
    private MultiWikiService _multiWikiService;
    @Autowired
    private EntityVersionService _entityVersionService;

    @Nonnull
    public BoolExpr hasRight(@Nonnull CalculationContext calculationContext, @Nonnull Item<?> item, @Nullable ComponentType childModuleType, @Nonnull Right right, @Nonnull ItemPathHelper itemPathHelper) {
        return item.accept(new HasRightVisitor(calculationContext, childModuleType, right, itemPathHelper));
    }

    @Nonnull
    private BoolExpr checkOptionsFor(@Nonnull Path path, @Nonnull Collection<String> authorityNames) {
        ImmutableCollection options = this._configFileService.getConfigFile().getConfOption(path).getOptions().values();
        ImmutableSet.Builder expr = ImmutableSet.builder();
        for (ConfOption option : options) {
            if (!option.isForced() && !authorityNames.contains(option.getName())) continue;
            expr.add((Object)option.getExpr());
        }
        return BoolExpr.or((Iterable<? extends BoolExpr>)expr.build());
    }

    private static final class MultiWikiVersionSectionKey
    extends AbstractImmutableEqualsObject {
        private final MultiWikiVersionSection _section;

        private MultiWikiVersionSectionKey(@Nonnull MultiWikiVersionSection section) {
            super(section.getId());
            this._section = section;
        }
    }

    private final class HasRightVisitor
    extends ItemVisitor.DefaultItemVisitor<BoolExpr> {
        private final ComponentType _childModuleType;
        private final Right _right;
        private final ItemPathHelper _itemPathHelper;
        private final CalculationContext _calculationContext;

        private HasRightVisitor(@Nullable CalculationContext calculationContext, @Nonnull ComponentType childModuleType, @Nonnull Right right, ItemPathHelper itemPathHelper) {
            this._calculationContext = calculationContext;
            this._childModuleType = childModuleType;
            this._right = right;
            this._itemPathHelper = itemPathHelper;
        }

        @Override
        public BoolExpr visit(EntityItem item) {
            return this._right.accept(new EntityItemRightVisitor(this._calculationContext, item, this._childModuleType));
        }

        @Override
        public BoolExpr visit(ProfileItem item) {
            return this._right.accept(new ProfileRightVisitor(item));
        }

        @Override
        public BoolExpr visit(SurveyItem surveyItem) {
            return this._right.accept(new SurveyRightVisitor(surveyItem.getSurvey()));
        }

        @Override
        public BoolExpr visit(final MultiWikiVersion multiWikiVersion) {
            return this._right.accept(new BaseRightVisitor(){

                @Override
                public BoolExpr visitMultiWikiVersionRead() {
                    MultiWikiVersionId multiWikiVersionId = multiWikiVersion.getId();
                    return HasRightVisitor.this._calculationContext.get((Authority)StaticRight.MULTI_WIKI_VERSION_READ, multiWikiVersionId, keys -> {
                        ImmutableSetMultimap<MultiWikiVersionId, EntityVersionId> versionIds = RightsService.this._entityVersionService.getEntityVersionsForMultiWikiVersions((Set<MultiWikiVersionId>)keys);
                        ImmutableMap<EntityVersionId, EntityVersion> versions = RightsService.this._entityVersionService.getVersionsByIds((Set<EntityVersionId>)versionIds.inverse().keySet());
                        return Maps.asMap((Set)keys, k -> FluentIterable.from((Iterable)versionIds.get(k)).transform(arg_0 -> ((ImmutableMap)versions).get(arg_0)).filter(Objects::nonNull).toList());
                    }, versions -> {
                        if (versions.isEmpty()) {
                            LOG.error("Cannot retrieve entity version for multi wiki version  " + multiWikiVersion.toString());
                            return BoolExpr.FALSE;
                        }
                        ImmutableSet.Builder result = ImmutableSet.builder();
                        try {
                            if (Iterables.any((Iterable)versions, v -> v.getStatus().isPublished())) {
                                result.add((Object)HasRightVisitor.this._itemPathHelper.createExpression(multiWikiVersion.getParentId(), (Action)StaticAction.MULTI_WIKI_READ));
                            }
                            if (Iterables.any((Iterable)versions, v -> !v.getStatus().isPublished())) {
                                EntityId entityId = (EntityId)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)versions).transform(EntityVersion::getEntityId).toSet());
                                result.add((Object)HasRightVisitor.this._itemPathHelper.createExpression(entityId, (Action)StaticEntityAction.ENTITY_READ_PRIVATE));
                            }
                        }
                        catch (InvalidIDException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                        return BoolExpr.or((Iterable<? extends BoolExpr>)result.build());
                    });
                }
            });
        }

        @Override
        public BoolExpr visit(final MultiWikiVersionSection multiWikiVersionSection) {
            return this._right.accept(new BaseRightVisitor(){

                @Override
                public BoolExpr visitMultiWikiVersionSectionRead() {
                    return HasRightVisitor.this._calculationContext.get((Authority)StaticRight.MULTI_WIKI_VERSION_SECTION_READ, new MultiWikiVersionSectionKey(multiWikiVersionSection), keys -> {
                        ImmutableMap.Builder sections = ImmutableMap.builder();
                        for (MultiWikiVersionSectionKey key : keys) {
                            sections.put((Object)key._section.getId(), (Object)key._section);
                        }
                        ImmutableMap<MultiWikiVersionSectionId, Path> paths = RightsService.this._multiWikiService.getPathsForWikiSectionRead((Map<MultiWikiVersionSectionId, MultiWikiVersionSection>)sections.build());
                        return Maps.asMap((Set)keys, input -> (Path)paths.get((Object)input._section.getId()));
                    }, result -> RightsService.this.checkOptionsFor((Path)result, (Collection<String>)multiWikiVersionSection.getSelectedRolesAllowedToRead()));
                }
            });
        }

        @Override
        public BoolExpr visit(PollItem pollItem) {
            return BoolExpr.FALSE;
        }

        @Override
        protected BoolExpr visitDefault(Item<?> item) {
            return BoolExpr.FALSE;
        }
    }

    private final class EntityItemRightVisitor
    extends BaseRightVisitor {
        private final DBEntity _entity;
        private final ComponentType _childModuleType;
        private final EntityItem _entityItem;
        private final CalculationContext _calculationContext;

        private EntityItemRightVisitor(@Nonnull CalculationContext calculationContext, @Nullable EntityItem entity, ComponentType childModuleType) {
            this._calculationContext = calculationContext;
            this._entity = entity.getEntity();
            this._entityItem = entity;
            this._childModuleType = childModuleType;
        }

        @Override
        public BoolExpr visitEntityRead() {
            ConfFile confFile = RightsService.this._configFileService.getConfigFile();
            ImmutableSet.Builder stateExpressions = ImmutableSet.builder();
            if (Iterables.any(this._entity.getEntityStatus(), (Predicate)Predicates.not(EntityStatus::isPublished))) {
                Path path = Path.builder().add(this._entityItem).buildWithAction(StaticEntityAction.ENTITY_READ_PRIVATE);
                stateExpressions.add((Object)confFile.getAction(path));
            }
            if (Iterables.any(this._entity.getEntityStatus(), EntityStatus::isPublished)) {
                stateExpressions.add((Object[])new BoolExpr[]{this.checkEntityPrivacySelection(DBPrivacyType.VISIBILITY), StaticPredefinedRole.ENTITY_CO_ADMIN.expr(), StaticPredefinedRole.ENTITY_ASSIGNEE.expr(), StaticPredefinedRole.ENTITY_VERSION_REVIEWER.expr()});
            }
            return BoolExpr.or((Iterable<? extends BoolExpr>)stateExpressions.build());
        }

        @Nonnull
        private BoolExpr checkEntityPrivacySelection(@Nonnull DBPrivacyType privacyType) {
            Right right = privacyType.getRight();
            return this._calculationContext.get((Authority)right, this._entity.getId(), keys -> Maps.asMap((Set)keys, arg_0 -> RightsService.this._entityService.getPrivacySelectedAuthoritiesFromDB((Set<EntityId>)keys).get(arg_0)), result -> {
                ImmutableSet<String> namesFromDB = AuthorityUtil.getAuthorityNamesForType((Iterable<DBPrivacySelection>)result, privacyType);
                return RightsService.this.checkOptionsFor(Path.builder().add(this._entityItem).add(right).build(), (Collection<String>)namesFromDB);
            });
        }

        @Override
        public BoolExpr visitEntityEdit() {
            return this.checkEntityPrivacySelection(DBPrivacyType.ENTITY_EDIT);
        }

        @Override
        public BoolExpr visitEntityWrite() {
            if (this._childModuleType == null) {
                return StaticPredefinedRole.ENTITY_CO_ADMIN.expr();
            }
            BoolExpr writeExpr = this._calculationContext.get((Authority)StaticRight.ENTITY_WRITE, new EntityKey(this._entity), keys -> {
                ImmutableTable<EntityId, ComponentType, DBEntityComponent> result = RightsService.this._entityService.getComponentsByEntities((Map<EntityId, DBEntity>)EntityKey.asMap(keys));
                return Maps.asMap((Set)keys, input -> {
                    if (input == null) {
                        return ImmutableMap.of();
                    }
                    return result.row((Object)input._entity.getId());
                });
            }, result -> {
                DBEntityComponent component = (DBEntityComponent)result.get((Object)this._childModuleType);
                ImmutableSet<String> openFor = component == null ? ImmutableSet.of() : component.getOpenForAuthNames();
                return RightsService.this.checkOptionsFor(Path.builder().add(this._entityItem).add(this._childModuleType).add(StaticRight.ENTITY_WRITE).build(), (Collection<String>)openFor);
            });
            return BoolExpr.or(StaticPredefinedRole.ENTITY_CO_ADMIN.expr(), BoolExpr.and(this.visitEntityRead(), writeExpr));
        }

        @Override
        public BoolExpr visitInvite() {
            return this.checkEntityPrivacySelection(DBPrivacyType.INVITING);
        }

        @Override
        public BoolExpr visitEntityModifyTitle() {
            return this.checkEntityPrivacySelection(DBPrivacyType.MODIFY_TITLE);
        }

        @Override
        public BoolExpr visitJoin() {
            return RightsService.this._entityConfig.getEntityMemberWorkflow(this._entityItem.getEntity().getType()).accept(new EntityMemberWorkflow.Visitor<BoolExpr>(){

                @Override
                public BoolExpr visitMember() {
                    return BoolExpr.and(EntityItemRightVisitor.this.checkEntityPrivacySelection(DBPrivacyType.JOINING), EntityItemRightVisitor.this.mayJoinOrRequestMembershipCondition());
                }

                @Override
                public BoolExpr visitEvent() {
                    return BoolExpr.and(EntityItemRightVisitor.this.checkEntityPrivacySelection(DBPrivacyType.JOINING), StaticPredefinedRole.EVENT_HAS_NO_STATUS.expr());
                }
            });
        }

        @Override
        public BoolExpr visitJoinRequest() {
            return RightsService.this._entityConfig.getEntityMemberWorkflow(this._entityItem.getEntity().getType()).accept(new EntityMemberWorkflow.Visitor<BoolExpr>(){

                @Override
                public BoolExpr visitMember() {
                    return BoolExpr.and(BoolExpr.not(EntityItemRightVisitor.this.checkEntityPrivacySelection(DBPrivacyType.JOINING)), EntityItemRightVisitor.this.checkEntityPrivacySelection(DBPrivacyType.JOIN_REQUEST), EntityItemRightVisitor.this.mayJoinOrRequestMembershipCondition());
                }

                @Override
                public BoolExpr visitEvent() {
                    return BoolExpr.FALSE;
                }
            });
        }

        @Nonnull
        private BoolExpr mayJoinOrRequestMembershipCondition() {
            return BoolExpr.and(StaticPredefinedRole.ENTITY_HAS_INVITATION.notExpr(), StaticPredefinedRole.ENTITY_HAS_SEND_JOINREQUEST.notExpr(), StaticPredefinedRole.ENTITY_MEMBER.notExpr(), StaticPredefinedRole.ENTITY_UNDECIDED.notExpr(), StaticPredefinedRole.ENTITY_HAS_REJECTED.notExpr());
        }

        @Override
        public BoolExpr visitRemoveJoinRequest() {
            return StaticPredefinedRole.ENTITY_HAS_SEND_JOINREQUEST.expr();
        }

        @Override
        public BoolExpr visitEntityAcceptInvite() {
            return BoolExpr.or(StaticPredefinedRole.ENTITY_HAS_INVITATION.expr(), StaticPredefinedRole.ENTITY_HAS_REJECTED.expr());
        }

        @Override
        public BoolExpr visitEntityDelete() {
            return RightsService.this._entityConfig.deleteByAdminActivated(this._entity.getType()) ? StaticPredefinedRole.ENTITY_ADMIN.expr() : BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visitEntityDeleteRequest() {
            return !RightsService.this._entityConfig.deleteByAdminActivated(this._entity.getType()) ? StaticPredefinedRole.ENTITY_ADMIN.expr() : BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visitEntityLeave() {
            return BoolExpr.and(StaticPredefinedRole.ENTITY_ADMIN.notExpr(), RightsService.this._entityConfig.leaveAllowed(this._entity.getType()) ? BoolExpr.or(StaticPredefinedRole.ENTITY_HAS_INVITATION.expr(), StaticPredefinedRole.ENTITY_MEMBER.expr(), StaticPredefinedRole.ENTITY_UNDECIDED.expr()) : StaticPredefinedRole.ENTITY_HAS_INVITATION.expr());
        }

        @Override
        public BoolExpr visitEntitySendNewsletter() {
            return this.checkEntityPrivacySelection(DBPrivacyType.NEWSLETTER);
        }

        @Override
        public BoolExpr visitEntityWriteInviteOptions() {
            return StaticPredefinedRole.ENTITY_CO_ADMIN.expr();
        }

        @Override
        public BoolExpr visitInviteEntityMembers() {
            return RightsService.this._settings.isOrdinaryUsersMayInviteMembers() ? BoolExpr.or(StaticPredefinedRole.ENTITY_MEMBER.expr(), StaticPredefinedRole.ENTITY_MEMBER_OF_PARENT.expr()) : StaticPredefinedRole.ENTITY_CO_ADMIN.expr();
        }

        @Override
        public BoolExpr visitEntityRecommendToMembers() {
            return RightsService.this._settings.isOrdinaryUsersMayRecommendToMembers() ? BoolExpr.or(StaticPredefinedRole.ENTITY_MEMBER.expr(), StaticPredefinedRole.ENTITY_MEMBER_OF_PARENT.expr()) : StaticPredefinedRole.ENTITY_CO_ADMIN.expr();
        }

        @Override
        public BoolExpr visitEntityChangeParent(EntityType param) {
            DynamicRight entityChangeParent = Rights.entityChangeParent(param);
            return this._calculationContext.get((Authority)entityChangeParent, new EntityKey(this._entity), keys -> {
                ImmutableListMultimap<EntityId, DBEntityLinkedEntityPrivacy> linkedPrivacies = RightsService.this._entityService.getEntityLinkedEntityPrivacies((Map<EntityId, DBEntity>)EntityKey.asMap(keys));
                return Maps.asMap((Set)keys, input -> linkedPrivacies.get(input != null ? input._entity.getId() : null));
            }, result -> {
                Path path = Path.builder().add(this._entityItem).add(entityChangeParent).build();
                for (DBEntityLinkedEntityPrivacy l : result) {
                    if (!param.equals(l.getEntityType())) continue;
                    return RightsService.this.checkOptionsFor(path, (Collection<String>)l.getSelectedAuthorityNames());
                }
                return RightsService.this.checkOptionsFor(path, (Collection<String>)ImmutableSet.of());
            });
        }
    }

    private static class EntityKey
    extends AbstractImmutableEqualsObject {
        public static final Function<EntityKey, DBEntity> TO_ENTITY = new NullPermeableFunction<EntityKey, DBEntity>(){

            @Override
            protected DBEntity applySafe(EntityKey input) {
                return input._entity;
            }
        };
        private final DBEntity _entity;

        EntityKey(@Nonnull DBEntity entity) {
            super(entity.getId());
            this._entity = entity;
        }

        @Nonnull
        public static ImmutableMap<EntityId, DBEntity> asMap(@Nonnull Set<EntityKey> keys) {
            return Maps.uniqueIndex((Iterable)Iterables.transform(keys, TO_ENTITY), DBEntity.TO_ENTITY_ID);
        }
    }

    private final class SurveyRightVisitor
    extends BaseRightVisitor {
        private final DBSurvey _survey;

        private SurveyRightVisitor(DBSurvey survey) {
            this._survey = survey;
        }

        @Override
        public BoolExpr visitSurveyReadResult() {
            switch (this._survey.getResultVisibility()) {
                case ADMIN_ONLY: {
                    return BoolExpr.FALSE;
                }
                case PARTICIPANT: {
                    return StaticPredefinedRole.SURVEY_PARTICIPANT.expr();
                }
                case PARTICIPANT_AND_ALL_AFTER_EXPIRED_TIME: {
                    return RightsService.this._surveyService.isExpired(this._survey) ? BoolExpr.TRUE : StaticPredefinedRole.SURVEY_PARTICIPANT.expr();
                }
            }
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visitSurveyUpdateAnswer() {
            return this._survey.isParticipantMayModify() && !RightsService.this._surveyService.isExpired(this._survey) ? StaticPredefinedRole.SURVEY_PARTICIPANT.expr() : BoolExpr.FALSE;
        }
    }

    private final class ProfileRightVisitor
    extends BaseRightVisitor {
        private final ProfileItem _item;

        private ProfileRightVisitor(ProfileItem item) {
            this._item = item;
        }

        @Override
        public BoolExpr visitPersonRemoveContact() {
            return BoolExpr.and(StaticPredefinedRole.PERSON_FRIEND.expr(), StaticPredefinedRole.PROFILE_OWNER.notExpr());
        }

        @Override
        public BoolExpr visitPersonSendMessage() {
            return BoolExpr.and(StaticPredefinedRole.LOGGED_IN.expr());
        }

        @Override
        public BoolExpr visitPersonAddContact() {
            return BoolExpr.and(StaticPredefinedRole.LOGGED_IN.expr(), StaticPredefinedRole.PROFILE_OWNER.notExpr(), StaticPredefinedRole.PERSON_FRIEND.notExpr(), StaticPredefinedRole.PERSON_HAS_INVITED.notExpr());
        }

        @Override
        public BoolExpr visitPersonRemoveInvitation() {
            return StaticPredefinedRole.PERSON_HAS_INVITED.expr();
        }
    }

    private static class BaseRightVisitor
    extends DefaultRightVisitor<BoolExpr> {
        private BaseRightVisitor() {
        }

        @Override
        protected final BoolExpr visitDefault(Right right) {
            return BoolExpr.FALSE;
        }
    }
}

