/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.google.common.base.Function;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import javax.annotation.Nonnull;

abstract class ItemOrItemIdContainer {
    public static final Function<Item<?>, ItemContainer> FROM_ITEM = new Function<Item<?>, ItemContainer>(){

        public ItemContainer apply(Item<?> input) {
            return input != null ? new ItemContainer(input) : null;
        }
    };
    public static final Function<ItemId, ItemIdContainer> FROM_ID = new Function<ItemId, ItemIdContainer>(){

        public ItemIdContainer apply(ItemId input) {
            return input != null ? new ItemIdContainer(input) : null;
        }
    };
    public static final Function<ItemOrItemIdContainer, ItemId> TO_ID = new Function<ItemOrItemIdContainer, ItemId>(){

        public ItemId apply(ItemOrItemIdContainer input) {
            return input != null ? input._id : null;
        }
    };
    private final ItemId _id;

    protected ItemOrItemIdContainer(@Nonnull ItemId id) {
        this._id = id;
    }

    @Nonnull
    public final ItemId getId() {
        return this._id;
    }

    @Nonnull
    public abstract <T> T accept(@Nonnull Visitor<T> var1);

    public final int hashCode() {
        return this._id.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof ItemOrItemIdContainer && this._id.equals(((ItemOrItemIdContainer)obj)._id);
    }

    public static interface Visitor<T> {
        @Nonnull
        public T visit(@Nonnull Item<?> var1);

        @Nonnull
        public T visit(@Nonnull ItemId var1);
    }

    public static class ItemIdContainer
    extends ItemOrItemIdContainer {
        public ItemIdContainer(@Nonnull ItemId id) {
            super(id);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this._id);
        }
    }

    public static class ItemContainer
    extends ItemOrItemIdContainer {
        private final Item<?> _item;

        public ItemContainer(@Nonnull Item<?> item) {
            super((ItemId)item.getId());
            this._item = item;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this._item);
        }
    }
}

