/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.BasePersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.impl.AbstractAuthorizationContextWithUserId;
import de.justsoftware.onx.authorization.business.impl.AuthorizationCheckContextWithRole;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultAuthorizationContextWithUserId
extends AbstractAuthorizationContextWithUserId {
    private final PersonId _userId;
    private final TenantId _tenantId;
    private final String _locale;
    private final BasePersonIndependentAuthorizationContext _basePersonIndependentAuthorizationContext;
    private final String _defaultLocale;

    DefaultAuthorizationContextWithUserId(PersonId uid, @Nullable TenantId tenantId, @Nullable String locale, String defaultLocale, BasePersonIndependentAuthorizationContext basePersonIndependentAuthorizationContext, PermissionRequestConnector permissionRequestConnector) {
        super(permissionRequestConnector);
        this._userId = uid;
        this._tenantId = tenantId;
        this._locale = locale;
        this._defaultLocale = defaultLocale;
        this._basePersonIndependentAuthorizationContext = basePersonIndependentAuthorizationContext;
    }

    @Override
    public final String getLocale() {
        String languageId;
        if (this._locale != null) {
            return this._locale;
        }
        DBPerson currentPerson = this.getCurrentPerson();
        if (currentPerson != null && (languageId = currentPerson.getLanguageId()) != null) {
            return languageId;
        }
        return this._defaultLocale;
    }

    @Override
    public final PersonId getUserId() {
        return this._userId;
    }

    @Override
    public TenantId getTenantId() {
        return this.getOptionalTenantId().orElseThrow(() -> new NotLoggedInException(String.format("user %s is not logged in to a tenant", this._userId)));
    }

    @Override
    public Optional<TenantId> getOptionalTenantId() {
        return Optional.ofNullable(this._tenantId);
    }

    @Override
    public BasePersonIndependentAuthorizationContext getPersonIndependentAuthorizationContext() {
        return this._basePersonIndependentAuthorizationContext;
    }

    @Override
    public AuthorizationCheckContext getContextForRoles(ImmutableSet<? extends Role> roles) {
        return new AuthorizationCheckContextWithRole(roles, this._basePersonIndependentAuthorizationContext, this._permissionRequestConnector);
    }

    @Override
    public boolean isAuthenticatedUser() {
        return true;
    }
}

