/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.BasePersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.impl.ContextCache;
import de.justsoftware.onx.authorization.business.impl.DefaultAuthorizationContextWithUserId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.searchnew.business.RolesSearchService;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

class DefaultAuthorizationContext
extends DefaultAuthorizationContextWithUserId
implements AuthorizationContext {
    private final RolesSearchService _rolesSearchService;
    private final Cache<ContextCache<?>, Object> _cache = CacheBuilder.newBuilder().maximumSize(100L).build();

    @ParametersAreNonnullByDefault
    DefaultAuthorizationContext(PersonId uid, @Nullable TenantId tenantId, @Nullable String locale, String defaultLocale, PersonService personService, RolesSearchService rolesSearchService, BasePersonIndependentAuthorizationContext basePersonIndependentAuthorizationContext, PermissionRequestConnector permissionRequestConnector) {
        super(uid, tenantId, locale, defaultLocale, basePersonIndependentAuthorizationContext, permissionRequestConnector);
        this._rolesSearchService = rolesSearchService;
    }

    @Override
    public ImmutableSet<String> getStaticUserRolesForSearchQuery() {
        return (ImmutableSet)new AuthorizationCache<ImmutableSet<String>>("getStaticUserRolesForSearchQuery", new Object[0]){

            @Override
            protected ImmutableSet<String> loadValue() {
                return DefaultAuthorizationContext.this._rolesSearchService.getStaticUserRolesForSearchQuery(DefaultAuthorizationContext.this.getUserId());
            }
        }.load();
    }

    @Override
    public AuthorizationContext asAuthorizationContext() throws NotLoggedInException {
        return this;
    }

    private abstract class AuthorizationCache<T>
    extends ContextCache<T> {
        AuthorizationCache(@Nonnull String method, Object ... params) {
            super(DefaultAuthorizationContext.this._cache, method, params);
        }
    }
}

